## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
suppressMessages(library(dplyr))
library(kableExtra)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)

repfun::rs_setup(D_POP='SAFFL',
         D_POPLBL='Safety',
         D_POPDATA=repfun::adsl %>%
           dplyr::filter(SAFFL =='Y'), D_SUBJID=c("STUDYID","USUBJID"),
         R_ADAMDATA=datdir)

G_POPDATA <- repfun:::rfenv$G_POPDATA %>%
  mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) %>%
  select(STUDYID,USUBJID,SAFFL,TRT01AN,TRT01A) %>%
  repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)'))

adae <- repfun:::rfenv$adamdata$adae.rda() %>% filter(TRTEMFL=='Y') %>%
        repfun::ru_getdata(G_POPDATA, c("STUDYID", "USUBJID"),keeppopvars=c("TRT01AN", "TRT01A", "SAFFL"))

## ----update, out.width="70%"--------------------------------------------------
addbign <- repfun::ru_addbignvar(adae,
                         G_POPDATA,
                         groupbyvars=c("TRT01AN", "TRT01A"),
                         countdistinctvars=c("STUDYID", "USUBJID"),
                         totalforvar=c("TRT01AN"),
                         totalid = 99,
                         totaldecode = 'Total',
                         codedecodevarpairs=c("TRT01AN", "TRT01A"),
                         varcodelistpairs=c(""),
                         codelistnames=list(),
                         addbigntovarvalue=TRUE,
                         splitchar="~") %>% select(STUDYID,USUBJID,TRT01AN,TRT01A,
                                                   AEBODSYS,AEDECOD) %>% 
           arrange(STUDYID, USUBJID, TRT01AN, TRT01A, AEBODSYS, AEDECOD)

## ----results1-----------------------------------------------------------------
lbls <- sapply(addbign,function(x){attr(x,"label")})
knitr::kable(
  head(addbign,10), col.names=paste(names(lbls),lbls,sep=": "), 
  caption = "Big N Added to ADAE (Attached to TRT01A - The last groupbyvars column)") %>% 
  kable_styling(full_width = T) %>% column_spec(c(2,4,5,6), width_min = '2in')

