## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(mixgb)
str(newborn)
colSums(is.na(newborn))

## ----eval = FALSE-------------------------------------------------------------
# # use mixgb with default settings
# imp_list <- mixgb(data = newborn, m = 5)

## ----eval = FALSE-------------------------------------------------------------
# set.seed(2026)
# # Use mixgb with chosen settings
# params <- list(
#   max_depth = 5,
#   subsample = 0.9,
#   nthread = 2,
#   tree_method = "hist"
# )
# 
# imp_list <- mixgb(
#   data = newborn, m = 10, maxit = 2,
#   ordinalAsInteger = FALSE,
#   pmm.type = "auto", pmm.k = 5, pmm.link = "prob",
#   initial.num = "normal", initial.int = "mode", initial.fac = "mode",
#   save.models = FALSE, save.vars = NULL,
#   xgb.params = params, nrounds = 200, early_stopping_rounds = 10, print_every_n = 10L, verbose = 0
# )

## -----------------------------------------------------------------------------
params <- list(max_depth = 3, subsample = 0.7, nthread = 2)
cv.results <- mixgb_cv(data = newborn, nrounds = 100, xgb.params = params, verbose = FALSE)
cv.results$evaluation.log
cv.results$response
cv.results$best.nrounds

## -----------------------------------------------------------------------------
cv.results <- mixgb_cv(
  data = newborn, nfold = 10, nrounds = 100, early_stopping_rounds = 1,
  response = "head_circumference_cm", select_features = c("age_months", "sex", "race_ethinicity", "recumbent_length_cm", "first_subscapular_skinfold_mm", "second_subscapular_skinfold_mm", "first_triceps_skinfold_mm", "second_triceps_skinfold_mm", "weight_kg"), xgb.params = params, verbose = FALSE
)

cv.results$best.nrounds

## ----eval = FALSE-------------------------------------------------------------
# imp_list <- mixgb(data = newborn, m = 5, nrounds = cv.results$best.nrounds)

