/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Fares;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.ArrayList;
import java.util.List;
import org.ipea.r5r.Fares.FarePerRoute;
import org.ipea.r5r.Fares.FarePerTransfer;
import org.ipea.r5r.Fares.FarePerType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FareStructure {
    private int maxDiscountedTransfers = 1;
    private int transferTimeAllowance = 120;
    private float fareCap = -1.0f;
    @JsonIgnore
    private int integerFareCap;
    private final List<FarePerType> faresPerType = new ArrayList<FarePerType>();
    private final List<FarePerTransfer> faresPerTransfer = new ArrayList<FarePerTransfer>();
    private final List<FarePerRoute> faresPerRoute = new ArrayList<FarePerRoute>();

    public int getMaxDiscountedTransfers() {
        return this.maxDiscountedTransfers;
    }

    public void setMaxDiscountedTransfers(int maxDiscountedTransfers) {
        this.maxDiscountedTransfers = maxDiscountedTransfers;
    }

    public int getTransferTimeAllowance() {
        return this.transferTimeAllowance;
    }

    @JsonIgnore
    public int getTransferTimeAllowanceSeconds() {
        return this.transferTimeAllowance * 60;
    }

    public void setTransferTimeAllowance(int transferTimeAllowance) {
        this.transferTimeAllowance = transferTimeAllowance;
    }

    public float getFareCap() {
        return this.fareCap;
    }

    public int getIntegerFareCap() {
        return this.integerFareCap;
    }

    public void setFareCap(float fareCap) {
        this.fareCap = fareCap;
        this.integerFareCap = Math.round(fareCap * 100.0f);
    }

    public List<FarePerType> getFaresPerType() {
        return this.faresPerType;
    }

    public List<FarePerTransfer> getFaresPerTransfer() {
        return this.faresPerTransfer;
    }

    public List<FarePerRoute> getFaresPerRoute() {
        return this.faresPerRoute;
    }

    public static FareStructure fromJson(String data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            return (FareStructure)objectMapper.readValue(data, FareStructure.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJson() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

