/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.pack.AbstractFindParameters;
import choco.kernel.common.opres.pack.AbstractFunctionDFF;
import choco.kernel.common.opres.pack.BestFit1BP;
import choco.kernel.common.opres.pack.ComputeL0;
import choco.kernel.common.opres.pack.FindParametersF0;
import choco.kernel.common.opres.pack.FindParametersFCCM1;
import choco.kernel.common.opres.pack.FirstFit1BP;
import choco.kernel.common.opres.pack.FunctionF0;
import choco.kernel.common.opres.pack.FunctionFCCM1;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;

public final class LowerBoundFactory {
    private static final ComputeL0 COMPUTE_L0 = new ComputeL0();
    private static final AbstractFindParameters FIND_PARAMETERS_F0 = new FindParametersF0();
    private static final AbstractFunctionDFF FUNCTION_F0 = new FunctionF0();
    private static final AbstractFindParameters FIND_PARAMETERS_FCCM1 = new FindParametersFCCM1();
    private static final AbstractFunctionDFF FUNCTION_FCCM1 = new FunctionFCCM1();
    private static final FirstFit1BP FIRST_FIT = new FirstFit1BP();
    private static final BestFit1BP BEST_FIT = new BestFit1BP();

    private LowerBoundFactory() {
    }

    public static int computeL0(TIntArrayList items, int capacity) {
        ComputeL0 l0 = new ComputeL0(capacity);
        items.forEachDescending(l0);
        return l0.getLowerBound();
    }

    public static final int computeF0(TIntArrayList items, int capacity, int upperBound) {
        return LowerBoundFactory.computeMDDFF(items, capacity, upperBound, new FindParametersF0(), new FunctionF0());
    }

    public static final int computeFCCM1(TIntArrayList items, int capacity, int upperBound) {
        return LowerBoundFactory.computeMDDFF(items, capacity, upperBound, new FindParametersFCCM1(), new FunctionFCCM1());
    }

    public static final int computeAllMDFF(TIntArrayList items, int capacity, int upperBound) {
        int lb = LowerBoundFactory.computeF0(items, capacity, upperBound);
        return lb >= upperBound ? lb : Math.max(lb, LowerBoundFactory.computeFCCM1(items, capacity, upperBound));
    }

    protected static final int computeMDDFF(TIntArrayList items, int capacity, int upperBound, AbstractFindParameters findParameters, AbstractFunctionDFF functionDDFF) {
        assert (LowerBoundFactory.checkIncreasingOrder(items));
        return LowerBoundFactory.computeMDDFF(items, items.toNativeArray(), capacity, upperBound, new ComputeL0(), findParameters, functionDDFF);
    }

    private static final int computeMDDFF(TIntArrayList items, int[] storedItems, int capacity, int upperBound, ComputeL0 computeL0, AbstractFindParameters findParameters, AbstractFunctionDFF functionDFF) {
        int lowerBound = 0;
        findParameters.clearParameters();
        findParameters.setCapacity(capacity);
        items.forEachDescending(findParameters);
        TIntHashSet parameters = findParameters.getParameters();
        if (!parameters.isEmpty()) {
            functionDFF.setCapacity(capacity);
            TIntArrayList transformedItems = new TIntArrayList(items.size());
            TIntIterator iter = parameters.iterator();
            while (iter.hasNext()) {
                functionDFF.setParameter(iter.next());
                transformedItems.resetQuick();
                transformedItems.add(storedItems);
                transformedItems.transformValues(functionDFF);
                computeL0.reset();
                computeL0.setCapacity(functionDFF.transformCapacity());
                transformedItems.forEachDescending(computeL0);
                if (lowerBound >= computeL0.getLowerBound() || (lowerBound = computeL0.getLowerBound()) < upperBound) continue;
                return lowerBound;
            }
        }
        return lowerBound;
    }

    public static int memComputeL0(TIntArrayList items, int capacity) {
        COMPUTE_L0.reset();
        COMPUTE_L0.setCapacity(capacity);
        items.forEachDescending(COMPUTE_L0);
        return COMPUTE_L0.getLowerBound();
    }

    public static int memComputeF0(TIntArrayList items, int capacity, int upperBound) {
        assert (LowerBoundFactory.checkIncreasingOrder(items));
        return LowerBoundFactory.computeMDDFF(items, items.toNativeArray(), capacity, upperBound, COMPUTE_L0, FIND_PARAMETERS_F0, FUNCTION_F0);
    }

    public static int memComputeFCCM1(TIntArrayList items, int capacity, int upperBound) {
        assert (LowerBoundFactory.checkIncreasingOrder(items));
        return LowerBoundFactory.computeMDDFF(items, items.toNativeArray(), capacity, upperBound, COMPUTE_L0, FIND_PARAMETERS_FCCM1, FUNCTION_FCCM1);
    }

    public static int memComputeAllMDFF(TIntArrayList items, int capacity, int upperBound) {
        assert (LowerBoundFactory.checkIncreasingOrder(items));
        int[] tab = items.toNativeArray();
        int lb = LowerBoundFactory.computeMDDFF(items, tab, capacity, upperBound, COMPUTE_L0, FIND_PARAMETERS_F0, FUNCTION_F0);
        return lb >= upperBound ? lb : Math.max(lb, LowerBoundFactory.computeMDDFF(items, tab, capacity, upperBound, COMPUTE_L0, FIND_PARAMETERS_FCCM1, FUNCTION_FCCM1));
    }

    public static boolean testPackingConsistencyWithMDFF(TIntArrayList sizes, int capacity, int maxNumberOfBins) {
        int ub2;
        sizes.sort();
        int ub1 = FIRST_FIT.executeQuick(sizes, capacity);
        if (ub1 > maxNumberOfBins && (ub2 = BEST_FIT.executeQuick(sizes, capacity)) > maxNumberOfBins) {
            return LowerBoundFactory.memComputeFCCM1(sizes, capacity, ub1 > ub2 ? ub1 : ub2) <= maxNumberOfBins;
        }
        return true;
    }

    private static boolean checkIncreasingOrder(TIntArrayList items) {
        int n = items.size();
        for (int i = 1; i < n; ++i) {
            if (items.getQuick(i) >= items.getQuick(i - 1)) continue;
            return false;
        }
        return true;
    }
}

