/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.structural;

import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.structural.ModelSpecification;
import java.util.Map;
import java.util.Objects;

public class BsmSpecification
implements IProcSpecification,
Cloneable {
    public static final String OPTIMIZER = "optimizer";
    public static final String TOL = "tol";
    public static final String DREGS = "diffuseregs";
    public static final String MSPEC = "modelspec";
    public static final double DEF_TOL = 1.0E-9;
    public static final Optimizer DEF_OPT = Optimizer.LevenbergMarquardt;
    public static final boolean DEF_DREGS = false;
    private ModelSpecification mspec_;
    private boolean dregs_ = false;
    private double tol_ = 1.0E-9;
    private Optimizer opt_ = DEF_OPT;

    public BsmSpecification() {
        this.mspec_ = new ModelSpecification();
    }

    public Optimizer getOptimizer() {
        return this.opt_;
    }

    public void setOptimizer(Optimizer opt) {
        this.opt_ = opt;
    }

    public double getPrecision() {
        return this.tol_;
    }

    public void setPrecision(double tol) {
        this.tol_ = tol;
    }

    public boolean isDiffuseRegressors() {
        return this.dregs_;
    }

    public void setDiffuseRegressors(boolean dregs) {
        this.dregs_ = dregs;
    }

    public ModelSpecification getModelSpecification() {
        return this.mspec_;
    }

    public void setModelSpecification(ModelSpecification mspec) {
        this.mspec_ = mspec;
    }

    @Override
    public BsmSpecification clone() {
        try {
            BsmSpecification spec = (BsmSpecification)super.clone();
            spec.mspec_ = this.mspec_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet mspec;
        InformationSet info = new InformationSet();
        if (this.tol_ != 1.0E-9 || verbose) {
            info.set(TOL, Double.valueOf(this.tol_));
        }
        if (this.opt_ != DEF_OPT || verbose) {
            info.set(OPTIMIZER, this.opt_.name());
        }
        if (this.dregs_ || verbose) {
            info.set(DREGS, Boolean.valueOf(this.dregs_));
        }
        if ((mspec = this.mspec_.write(verbose)) != null) {
            info.set(MSPEC, mspec);
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        Boolean dregs;
        String opt;
        if (info == null) {
            return true;
        }
        Double tol = info.get(TOL, Double.class);
        if (tol != null) {
            this.tol_ = tol;
        }
        if ((opt = info.get(OPTIMIZER, String.class)) != null) {
            this.opt_ = Optimizer.valueOf(opt);
        }
        if ((dregs = info.get(DREGS, Boolean.class)) != null) {
            this.dregs_ = dregs;
        }
        return this.mspec_.read(info.getSubSet(MSPEC));
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BsmSpecification && this.equals((BsmSpecification)obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.dregs_ ? 1 : 0);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.tol_) ^ Double.doubleToLongBits(this.tol_) >>> 32);
        hash = 67 * hash + Objects.hashCode((Object)this.opt_);
        return hash;
    }

    private boolean equals(BsmSpecification spec) {
        return spec.dregs_ == this.dregs_ && spec.opt_ == this.opt_ && spec.tol_ == this.tol_ && Objects.deepEquals(spec.mspec_, this.mspec_);
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, OPTIMIZER), String.class);
        dic.put(InformationSet.item(prefix, TOL), Double.class);
        dic.put(InformationSet.item(prefix, DREGS), Boolean.class);
        ModelSpecification.fillDictionary(InformationSet.item(prefix, MSPEC), dic);
    }

    public static enum Optimizer {
        LevenbergMarquardt,
        MinPack,
        LBFGS;

    }
}

