/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.bfgs;

import ec.tstoolkit.maths.realfunctions.bfgs.ILineFunction;
import ec.tstoolkit.maths.realfunctions.bfgs.ILineSearch;

public class IterativeLineSearch
implements ILineSearch {
    private double m_eps = 1.0E-9;
    private double m_dfac = 0.5;
    private double m_ifac = 2.0;

    @Override
    public IterativeLineSearch exemplar() {
        IterativeLineSearch ls = new IterativeLineSearch();
        ls.m_dfac = this.m_dfac;
        ls.m_ifac = this.m_ifac;
        ls.m_eps = this.m_eps;
        return ls;
    }

    @Override
    public boolean optimize(ILineFunction fn, double start) {
        double stpmax = fn.getStepMax();
        if (stpmax < this.m_eps) {
            return true;
        }
        double stp = start;
        if (stp > stpmax) {
            stp = stpmax;
        }
        double f0 = fn.getValue();
        fn.setStep(stp);
        double fcur = fn.getValue();
        if (fn.getDerivative() > 0.0) {
            double fprev;
            double smin = fn.getStepMin();
            do {
                fprev = fcur;
                if ((stp *= this.m_dfac) < smin) break;
                fn.setStep(stp);
            } while ((fcur = fn.getValue()) < fprev || fprev > f0);
            if (fprev > f0) {
                return false;
            }
            fn.setStep(stp / this.m_dfac);
            return true;
        }
        if (stp != stpmax) {
            double fprev;
            do {
                fprev = fcur;
                if ((stp *= this.m_ifac) >= stpmax) break;
                fn.setStep(stp);
            } while ((fcur = fn.getValue()) < fprev || fprev > f0);
            if (fprev > f0) {
                return false;
            }
            fn.setStep(stp / this.m_ifac);
            return true;
        }
        return fcur < f0;
    }
}

