/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.businesscycle.simplets.TsHodrickPrescott;
import ec.satoolkit.DecompositionMode;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import java.text.DecimalFormat;

public class StationaryVarianceDecomposition {
    private double varC;
    private double varS;
    private double varI;
    private double varP;
    private double varCal;
    private final ILongTermTrendComputer trendComputer;
    private static final String nl = System.lineSeparator();

    public StationaryVarianceDecomposition() {
        this.trendComputer = new HPTrendComputer();
    }

    public StationaryVarianceDecomposition(ILongTermTrendComputer trendComputer) {
        this.trendComputer = trendComputer;
    }

    public ILongTermTrendComputer getTrendComputer() {
        return this.trendComputer;
    }

    public boolean process(TsData O, TsData T2, TsData S, TsData I, TsData Cal, TsData others, boolean mul) {
        TsData Pc;
        TsData Calc;
        TsData Ic;
        TsData Sc;
        TsData stCc;
        TsData stOc;
        if (O == null) {
            return false;
        }
        if (mul) {
            stOc = O.log();
            stCc = T2 != null ? T2.log() : null;
            Sc = S != null ? S.log() : null;
            Ic = I != null ? I.log() : null;
            Calc = Cal != null ? Cal.log() : null;
            Pc = others != null ? others.log() : null;
        } else {
            stOc = O;
            stCc = T2;
            Sc = S;
            Ic = I;
            Calc = Cal;
            Pc = others;
        }
        TsData lt = this.trendComputer.calcLongTermTrend(stCc);
        stCc = TsData.subtract(stCc, lt);
        stOc = TsData.subtract(stOc, lt);
        DescriptiveStatistics stats = new DescriptiveStatistics(stOc);
        double varO = stats.getVar();
        if (stCc != null) {
            stats = new DescriptiveStatistics(stCc);
            this.varC = stats.getVar();
        } else {
            this.varC = 0.0;
        }
        if (Sc != null) {
            stats = new DescriptiveStatistics(Sc);
            this.varS = stats.getVar();
        } else {
            this.varS = 0.0;
        }
        if (Ic != null) {
            stats = new DescriptiveStatistics(Ic);
            this.varI = stats.getVar();
        } else {
            this.varI = 0.0;
        }
        if (Calc != null) {
            stats = new DescriptiveStatistics(Calc);
            this.varCal = stats.getVar();
        } else {
            this.varCal = 0.0;
        }
        if (Pc != null) {
            stats = new DescriptiveStatistics(Pc);
            this.varP = stats.getVar();
        } else {
            this.varP = 0.0;
        }
        this.varP /= varO;
        this.varCal /= varO;
        this.varS /= varO;
        this.varC /= varO;
        this.varI /= varO;
        return true;
    }

    public boolean process(IProcResults results) {
        TsData O = results.getData("yc", TsData.class);
        TsData T2 = results.getData("t_cmp", TsData.class);
        TsData S = results.getData("s_cmp", TsData.class);
        TsData I = results.getData("i_cmp", TsData.class);
        TsData Cal = results.getData("cal", TsData.class);
        TsData D = results.getData("det", TsData.class);
        DecompositionMode m = results.getData("mode", DecompositionMode.class);
        boolean mul = m != null ? m != DecompositionMode.Additive : false;
        TsData P = mul ? TsData.divide(D, Cal) : TsData.subtract(D, Cal);
        return this.process(O, T2, S, I, Cal, P, mul);
    }

    public double getVarI() {
        return this.varI;
    }

    public double getVarS() {
        return this.varS;
    }

    public double getVarC() {
        return this.varC;
    }

    public double getVarP() {
        return this.varP;
    }

    public double getVarTD() {
        return this.varCal;
    }

    public double getVarTotal() {
        return this.varC + this.varS + this.varI + this.varP + this.varCal;
    }

    public String toString() {
        DecimalFormat dg1 = new DecimalFormat("0.#");
        StringBuilder builder = new StringBuilder();
        builder.append("C: ").append(dg1.format(this.varC * 100.0)).append(nl);
        builder.append("S: ").append(dg1.format(this.varS * 100.0)).append(nl);
        builder.append("I: ").append(dg1.format(this.varI * 100.0)).append(nl);
        builder.append("TD+Hol: ").append(dg1.format(this.varCal * 100.0)).append(nl);
        builder.append("P: ").append(dg1.format(this.varP * 100.0)).append(nl);
        return builder.toString();
    }

    public static class HPTrendComputer
    implements ILongTermTrendComputer {
        private final double cyclelen;

        public HPTrendComputer() {
            this.cyclelen = 8.0;
        }

        public HPTrendComputer(double len) {
            this.cyclelen = len;
        }

        @Override
        public TsData calcLongTermTrend(TsData s) {
            TsHodrickPrescott hp = new TsHodrickPrescott();
            hp.setCycleLength(this.cyclelen);
            if (hp.process(s)) {
                return hp.getTrend();
            }
            return null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Trend computed by Hodrick-Prescott filter (cycle length = ").append(this.cyclelen).append(" years)");
            return builder.toString();
        }
    }

    public static class LinearTrendComputer
    implements ILongTermTrendComputer {
        @Override
        public TsData calcLongTermTrend(TsData s) {
            if (s == null) {
                return null;
            }
            RegModel model = new RegModel();
            model.setY(TsDataBlock.all((TsData)s).data);
            model.setMeanCorrection(true);
            DataBlock x = new DataBlock(s.getLength());
            x.set(1.0);
            x.cumul();
            model.addX(x);
            Ols ols = new Ols();
            if (ols.process(model)) {
                double[] b = ols.getLikelihood().getB();
                x.mul(b[1]);
                x.add(b[0]);
                return new TsData(s.getStart(), x);
            }
            return null;
        }

        public String toString() {
            return "Linear trend computed by Ols";
        }
    }

    public static interface ILongTermTrendComputer {
        public TsData calcLongTermTrend(TsData var1);
    }
}

