/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class ContinuousDistribution
implements Distribution {
    public int decPrec = 15;
    protected static final double X_EPSILON = 0.001;
    protected static final double XBIG = 100.0;
    protected static final double XBIGM = 1000.0;
    protected double supportA = Double.NEGATIVE_INFINITY;
    protected double supportB = Double.POSITIVE_INFINITY;
    protected static final double[] EPSARRAY = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18, 5.0E-19, 5.0E-20, 5.0E-21, 5.0E-22, 5.0E-23, 5.0E-24, 5.0E-25, 5.0E-26, 5.0E-27, 5.0E-28, 5.0E-29, 5.0E-30, 5.0E-31, 5.0E-32, 5.0E-33, 5.0E-34, 5.0E-35, 5.0E-36};

    public abstract double density(double var1);

    private void findInterval(double d, double[] dArray) {
        double d2;
        double d3;
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        for (d3 = 8.0; d3 < 8.988465674311579E307 && d > this.cdf(d3); d3 *= 2.0) {
        }
        if (d3 > 8.0) {
            dArray[0] = d3 / 2.0;
            dArray[1] = Math.min(d3, this.supportB);
            return;
        }
        for (d2 = -8.0; d2 > -8.988465674311579E307 && d < this.cdf(d2); d2 *= 2.0) {
        }
        if (d2 < -8.0) {
            dArray[1] = d2 / 2.0;
            dArray[0] = Math.max(d2, this.supportA);
            return;
        }
        dArray[0] = Math.max(d2, this.supportA);
        dArray[1] = Math.min(d3, this.supportB);
    }

    public double inverseBrent(double d, double d2, double d3, double d4) {
        int n;
        double d5;
        if (d3 > 1.0 || d3 < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d2 < d) {
            double d6 = d;
            d = d2;
            d2 = d6;
        }
        if (d3 <= 0.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 0");
            return this.supportA;
        }
        if (d3 >= 1.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 1");
            return this.supportB;
        }
        d4 += EPSARRAY[this.decPrec] + 2.220446049250313E-16;
        double d7 = this.cdf(d) - d3;
        if (d7 > 0.0) {
            throw new IllegalArgumentException("u < cdf(a)");
        }
        double d8 = this.cdf(d2) - d3;
        if (d8 < 0.0) {
            throw new IllegalArgumentException("u > cdf(b)");
        }
        double d9 = d;
        double d10 = d7;
        double d11 = d5 = d2 - d;
        if (Math.abs(d10) < Math.abs(d8)) {
            d = d2;
            d2 = d9;
            d9 = d;
            d7 = d8;
            d8 = d10;
            d10 = d7;
        }
        for (n = 0; n < 50; ++n) {
            double d12 = d4 + 8.881784197001252E-16 * Math.abs(d2);
            double d13 = 0.5 * (d9 - d2);
            if (Math.abs(d8) == 0.0 || Math.abs(d13) <= d12) {
                if (d2 <= this.supportA) {
                    return this.supportA;
                }
                if (d2 >= this.supportB) {
                    return this.supportB;
                }
                return d2;
            }
            if (Math.abs(d11) >= d12 && Math.abs(d7) > Math.abs(d8)) {
                double d14;
                double d15;
                double d16;
                if (d == d9) {
                    d16 = d8 / d7;
                    d15 = 1.0 - d16;
                    d14 = 2.0 * d13 * d16;
                } else {
                    d15 = d7 / d10;
                    double d17 = d8 / d10;
                    d16 = d8 / d7;
                    d14 = d16 * (2.0 * d13 * d15 * (d15 - d17) - (d2 - d) * (d17 - 1.0));
                    d15 = (d15 - 1.0) * (d17 - 1.0) * (d16 - 1.0);
                }
                if (d14 > 0.0) {
                    d15 = -d15;
                }
                if (2.0 * (d14 = Math.abs(d14)) >= 3.0 * d13 * d15 - Math.abs(d15 * d12) || d14 >= Math.abs(0.5 * d11 * d15)) {
                    d11 = d5 = d13;
                } else {
                    d11 = d5;
                    d5 = d14 / d15;
                }
            } else {
                d11 = d5 = d13;
            }
            d = d2;
            d7 = d8;
            d2 = Math.abs(d5) > d12 ? (d2 += d5) : (d13 < 0.0 ? (d2 -= d12) : (d2 += d12));
            d8 = this.cdf(d2) - d3;
            if (d8 * (d10 / Math.abs(d10)) > 0.0) {
                d9 = d;
                d10 = d7;
                d11 = d5 = d2 - d;
                continue;
            }
            if (!(Math.abs(d10) < Math.abs(d8))) continue;
            d = d2;
            d2 = d9;
            d9 = d;
            d7 = d8;
            d8 = d10;
            d10 = d7;
        }
        if (n >= 50) {
            System.out.println("\n*********** inverseBrent:   no convergence after 50 iterations");
        }
        return d2;
    }

    public double barF(double d) {
        return 1.0 - this.cdf(d);
    }

    private int getDecPrec() {
        return this.decPrec;
    }

    public double inverseF(double d) {
        if (d == 0.0) {
            return this.supportA;
        }
        if (d == 1.0) {
            return this.supportB;
        }
        double[] dArray = new double[2];
        this.findInterval(d, dArray);
        return this.inverseBrent(dArray[0], dArray[1], d, EPSARRAY[this.decPrec]);
    }

    public double inverseBisection(double d) {
        double d2 = EPSARRAY[this.decPrec];
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (this.decPrec > 15) {
            throw new IllegalArgumentException("decPrec too large");
        }
        if (this.decPrec <= 0) {
            throw new IllegalArgumentException("decPrec <= 0");
        }
        double d3 = 0.0;
        if (d <= 0.0) {
            d3 = this.supportA;
            return d3;
        }
        if (d >= 1.0) {
            d3 = this.supportB;
            return d3;
        }
        double[] dArray = new double[2];
        this.findInterval(d, dArray);
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = this.cdf(d5) - d;
        double d7 = this.cdf(d4) - d;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            d3 = (d4 + d5) / 2.0;
            double d8 = this.cdf(d3) - d;
            if (d8 == 0.0 || Math.abs((d5 - d4) / (d3 + 2.220446049250313E-16)) <= d2) {
                bl = true;
            } else if (d8 * d7 < 0.0) {
                d5 = d3;
            } else {
                d4 = d3;
            }
            if (++n <= 100) continue;
            bl = true;
        }
        return d3;
    }
}

