/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.util;

import java.io.IOException;
import java.io.OutputStream;
import org.openfast.ByteUtil;

public class RecordingOutputStream
extends OutputStream {
    private byte[] buffer = new byte[1024];
    private int index = 0;
    private OutputStream out;

    public RecordingOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int b) throws IOException {
        this.buffer[this.index++] = (byte)b;
        this.out.write(b);
    }

    public String toString() {
        return ByteUtil.convertByteArrayToBitString(this.buffer, this.index);
    }

    public void clear() {
        this.index = 0;
    }
}

