# Load default settings for CHNOSZ
reset()

info <- "Unavailable elements cause errors in mass() and entropy()"
# the suppressWarnings here refer to the warnings generated by makeup() about the missing elements
expect_error(suppressWarnings(mass("Xxx")), "element\\(s\\) Xxx not available in thermo\\(\\)\\$element", info = info)
# 20130101: the error below was changed to a warning to restore functionality of check.OBIGT()
#   (species in the database include those with Am Cm Np Pu, not listed in thermo()$element)
expect_warning(entropy("Xxx"), "element\\(s\\) Xxx not available in thermo\\(\\)\\$element", info = info)

info <- "GHS() and ZC() give warnings and errors in some situation"
expect_error(GHS(c("CO2","H2O"), G = 0, H = 0), "formula, G, H and S arguments are not same length", info = info)
expect_error(ZC("H2O"), "carbon not found in the stoichiometric matrix", info = info)
iATP <- info("ATP-4")
expect_warning(ZC(iATP), "element\\(s\\) P .* not included in this calculation", info = info)

info <- "GHS() and OBIGT2eos() produce expected values"
## a species with missing entropy value
ic <- info("cystine")
icdata <- info(ic)
GHS <- GHS(icdata$formula, G = icdata$G, H = icdata$H, S = icdata$S)
expect_equal(GHS[[3]], 61.8102928143, info = info)
# done through OBIGT2eos
coe <- CHNOSZ:::OBIGT2eos(thermo()$OBIGT[ic,], "aq", fixGHS = TRUE)
expect_equal(coe$S, GHS[[3]], info = info)
## mass and entropy of elements in chemical formulas
# the "-1" is a single negative charge, the electron
testform <- c("CH4", "H2O", "-1")
testmass <- mass(testform)
testent <- entropy(testform)
expect_equal(testmass, c(16.04276, 18.01528, 0), info = info)
expect_equal(testent, c(63.83843212237, 55.74952198853, 15.61663479924), info = info)
# another way to calculate the entropy of the elements in H2O
testGHS <- GHS("H2O", G = 0, H = 0)
expect_equal(as.numeric(testGHS[1, 3]), testent[2], info = info)
  
info <- "expr.species() produces expected errors"
expect_error(expr.species(c("H2O", "CO2")), "more than one species", info = info)

info <- "[P|T|E].units() do not accept invalid units"
expect_error(P.units("X"), "units of pressure must be either bar or MPa", info = info)
expect_error(T.units("X"), "units of temperature must be either C or K", info = info)
expect_error(E.units("X"), "units of energy must be either cal or J", info = info)

info <- "describe.property() does not accept NULL values"
expect_error(describe.property(), "property or value is NULL", info = info)
