/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbol;

class SimpleBasisSymbol
extends SimpleSymbol
implements BasisSymbol {
    protected List symbols;

    protected SimpleBasisSymbol(char c, Annotation annotation) {
        super(c, annotation);
    }

    protected SimpleBasisSymbol(char c, Annotation annotation, List list) throws IllegalSymbolException {
        this(c, annotation);
        if (list == null) {
            throw new NullPointerException("symbols can't be null");
        }
        if (list.size() == 0) {
            throw new IllegalSymbolException("Can't create BasisSymbol for an empty list. Use the Gap symbol.");
        }
        this.symbols = Collections.unmodifiableList(new ArrayList(list));
    }

    public SimpleBasisSymbol(char c, Annotation annotation, List list, Alphabet alphabet) throws IllegalSymbolException {
        this(c, annotation, list);
        this.matches = alphabet;
    }

    public SimpleBasisSymbol(char c, Annotation annotation, Alphabet alphabet) {
        this(c, annotation);
        this.matches = alphabet;
        this.symbols = Collections.nCopies(1, this);
    }

    protected List createSymbols() {
        throw new BioError("Assertion Failure: Symbols list is null");
    }

    public final List getSymbols() {
        if (this.symbols == null) {
            this.symbols = this.createSymbols();
        }
        if (this.symbols.size() == 0) {
            throw new BioError("Assertion Failure: symbols array is of length 0 in " + this + "\n\ttoken: " + this.getToken() + "\n\tname: " + this.getName() + "\n\tsymbols: " + this.symbols + "\n\tmatches: " + this.matches);
        }
        return this.symbols;
    }
}

