/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeAlignmentSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.HSPSummaryHelper;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class HitSectionSAXParser
extends AbstractNativeAppSAXParser {
    private BlastLikeAlignmentSAXParser oAlignmentParser;
    private BlastLikeVersionSupport oVersion;
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private char[] aoLineSeparator;
    private String oGlobalEndSignal;
    private ArrayList oBuffer = new ArrayList();
    private ArrayList oAlignmentBuffer = new ArrayList();
    private StringBuffer oStringBuffer = new StringBuffer();
    private StringBuffer oDescription = new StringBuffer();
    private String oLine;
    private HashMap oMap = new HashMap();
    private String[] aoKeys;
    private String[] aoArrayType = new String[1];
    private boolean tClearOfWarning = true;
    private static final int STARTUP = 0;
    private static final int DONE = 1;
    private static final int CAPTURING_HIT_SUMMARY = 2;
    private static final int IN_HSP_COLLECTION = 3;
    private static final int ON_FIRST_HSP = 4;
    private static final int IN_HSP_SUMMARY = 5;
    private static final int IN_ALIGNMENT = 6;

    HitSectionSAXParser(BlastLikeVersionSupport blastLikeVersionSupport, String string) {
        this.oVersion = blastLikeVersionSupport;
        this.setNamespacePrefix(string);
        this.changeState(0);
        this.aoLineSeparator = System.getProperty("line.separator").toCharArray();
    }

    private void firstHSPEvent(String string) throws SAXException {
        this.changeState(4);
        try {
            this.oLine = string;
            while (this.oLine != null && !this.oLine.trim().startsWith(">") && !this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
                this.interpretHSP(this.oLine);
                this.oLine = this.oContents.readLine();
            }
            if (this.iState != 4) {
                this.outputHSPInfo();
                this.endElement(new QName(this, this.prefix("HSP")));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("File read interupted");
        }
        if (this.oLine.startsWith(">")) {
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(this.oLine.substring(1));
            return;
        }
        if (this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
            this.changeState(1);
            return;
        }
    }

    private void interpret(String string) throws SAXException {
        if (string.startsWith(">")) {
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(string.substring(1));
            this.changeState(2);
            return;
        }
        if (this.iState == 2) {
            if (string.trim().startsWith("Length =")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n = stringTokenizer.countTokens() - 1;
                int n2 = 0;
                while (n2 < n) {
                    stringTokenizer.nextToken();
                    ++n2;
                }
                String string2 = stringTokenizer.nextToken();
                this.oAtts.clear();
                this.oAttQName.setQName("sequenceLength");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string2);
                this.startElement(new QName(this, this.prefix("Hit")), this.oAtts);
                stringTokenizer = new StringTokenizer(this.oStringBuffer.toString());
                int n3 = stringTokenizer.countTokens();
                String string3 = stringTokenizer.nextToken();
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string3);
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("HitId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("HitId")));
                this.oDescription.setLength(0);
                if (n3 > 0) {
                    while (stringTokenizer.hasMoreTokens()) {
                        this.oDescription.append(String.valueOf(stringTokenizer.nextToken()) + " ");
                    }
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("HitDescription")), this.oAtts);
                    this.aoChars = this.oDescription.toString().trim().toCharArray();
                    this.characters(this.aoChars, 0, this.aoChars.length);
                    this.endElement(new QName(this, this.prefix("HitDescription")));
                }
                this.changeState(3);
                return;
            }
            this.oStringBuffer.append(" " + string.trim());
            return;
        }
        if (this.iState == 3 && string.trim().startsWith("Score")) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("HSPCollection")), this.oAtts);
            this.firstHSPEvent(string);
            this.endElement(new QName(this, this.prefix("HSPCollection")));
            this.endElement(new QName(this, this.prefix("Hit")));
            this.changeState(2);
        }
    }

    private void interpretHSP(String string) throws SAXException {
        if (!this.tClearOfWarning) {
            if (string.trim().equals("")) {
                this.tClearOfWarning = true;
            }
            return;
        }
        if (string.trim().toLowerCase().startsWith("minus strand")) {
            return;
        }
        if (string.trim().toLowerCase().startsWith("plus strand")) {
            return;
        }
        if (string.trim().toLowerCase().startsWith("warning")) {
            this.tClearOfWarning = false;
            return;
        }
        if (string.trim().startsWith("Score")) {
            if (this.iState != 4) {
                this.outputHSPInfo();
                this.endElement(new QName(this, this.prefix("HSP")));
            }
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("HSP")), this.oAtts);
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(string);
            this.oBuffer.clear();
            this.oBuffer.add(string);
            this.changeState(5);
            return;
        }
        if (this.iState == 5) {
            if (string.startsWith("Query:")) {
                HSPSummaryHelper.parse(this.oStringBuffer.toString(), this.oMap, this.oVersion);
                this.changeState(6);
                this.oAlignmentBuffer.clear();
                this.oAlignmentBuffer.add(string);
                return;
            }
            if (string.trim().equals("")) {
                return;
            }
            this.oBuffer.add(string);
            this.oStringBuffer.append(", ");
            this.oStringBuffer.append(string);
            return;
        }
        if (this.iState == 6) {
            if (string.trim().equals("")) {
                return;
            }
            this.oAlignmentBuffer.add(string);
            return;
        }
    }

    private void outputHSPInfo() throws SAXException {
        this.aoKeys = this.oMap.keySet().toArray(this.aoArrayType);
        this.oAtts.clear();
        int n = 0;
        while (n < this.aoKeys.length) {
            if (this.aoKeys[n].equals("queryFrame") || this.aoKeys[n].equals("hitFrame") || this.aoKeys[n].equals("queryStrand") || this.aoKeys[n].equals("hitStrand")) {
                this.oAttQName.setQName(this.aoKeys[n]);
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", (String)this.oMap.get(this.aoKeys[n]));
            } else {
                this.oAttQName.setQName(this.aoKeys[n]);
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[n]));
            }
            ++n;
        }
        this.startElement(new QName(this, this.prefix("HSPSummary")), this.oAtts);
        this.oAtts.clear();
        this.oAttQName.setQName("xml:space");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
        this.startElement(new QName(this, this.prefix("RawOutput")), this.oAtts);
        int n2 = this.oBuffer.size();
        int n3 = 0;
        while (n3 < n2) {
            this.aoChars = ((String)this.oBuffer.get(n3)).toCharArray();
            this.characters(this.aoChars, 0, this.aoChars.length);
            this.characters(this.aoLineSeparator, 0, 1);
            ++n3;
        }
        this.endElement(new QName(this, this.prefix("RawOutput")));
        this.endElement(new QName(this, this.prefix("HSPSummary")));
        this.oAlignmentParser = new BlastLikeAlignmentSAXParser(this.getNamespacePrefix());
        this.oAlignmentParser.setContentHandler(this.oHandler);
        this.oAlignmentParser.parse(this.oAlignmentBuffer);
    }

    public void parse(BufferedReader bufferedReader, String string, String string2) throws SAXException {
        this.oLine = null;
        this.oContents = bufferedReader;
        this.oGlobalEndSignal = string2;
        if (!string.startsWith(">")) {
            return;
        }
        try {
            this.oLine = string;
            while (this.oLine != null && !this.oLine.trim().startsWith(this.oGlobalEndSignal) && this.iState != 1) {
                this.interpret(this.oLine);
                if (this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
                    this.changeState(1);
                    break;
                }
                this.oLine = this.oContents.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("File read interupted");
        }
    }
}

