### Name: dbReadTable-methods
### Title: Convenience functions for Importing/Exporting DBMS tables
### Aliases: dbReadTable dbWriteTable dbExistsTable dbRemoveTable
###   dbReadTable-methods dbWriteTable-methods dbExistsTable-methods
###   dbRemoveTable-methods dbReadTable,DBIConnection,character-method
###   dbWriteTable,DBIConnection,character,data.frame-method
###   dbExistsTable,DBIConnection,character-method
###   dbRemoveTable,DBIConnection,character-method
### Keywords: interface interface database

### ** Examples
## Not run: 
##D conn <- dbConnect("MySQL", group = "vitalAnalysis")
##D con2 <- dbConnect("Oracle", username = "user", password = "pwd")
##D if(dbExistsTable(con2, "fuel_frame")){
##D    fuel.frame <- dbReadTable(con2, "fuel_frame")
##D    dbRemoveTable(conn, "fuel_frame")
##D    dbWriteTable(conn, "fuel_frame", fuel.frame)
##D }
##D if(dbExistsTable(conn, "RESULTS")){
##D    dbWriteTable(conn, "RESULTS", results2000, append = T)
##D else
##D    dbWriteTable(conn, "RESULTS", results2000)
##D }
## End(Not run)



