/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.LocalVariable;

class LocalVariableInstruction
implements Instruction {
    private LocalVariable var;
    private byte opcode;
    private byte specialOpCodeBase;

    LocalVariableInstruction(byte by, byte by2, LocalVariable localVariable) {
        if (localVariable == null) {
            throw new NullPointerException("LocalVariable can not be null");
        }
        this.opcode = by;
        this.specialOpCodeBase = by2;
        this.var = localVariable;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        int n = codeContext.resolveLocal(this.var);
        if (n <= 3) {
            codeContext.writeByte((byte)(this.specialOpCodeBase + n));
        } else if (n < 256) {
            codeContext.writeByte(this.opcode);
            codeContext.writeByte((byte)n);
        } else {
            codeContext.writeByte((byte)-60);
            codeContext.writeByte(this.opcode);
            codeContext.writeShort(n);
        }
    }
}

