/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractDistribution
implements Distribution {
    protected transient ChangeSupport changeSupport = null;
    protected transient Distribution.NullModelForwarder nullModelForwarder = null;

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    private void doSetWeight(Symbol symbol, double d) throws IllegalSymbolException, ChangeVetoException {
        if (symbol instanceof AtomicSymbol) {
            this.setWeightImpl((AtomicSymbol)symbol, d);
        } else {
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)symbol.getMatches();
            Iterator iterator = finiteAlphabet.iterator();
            while (iterator.hasNext()) {
                AtomicSymbol atomicSymbol = (AtomicSymbol)iterator.next();
                this.setWeightImpl(atomicSymbol, d);
            }
        }
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        if ((changeType == null || changeType == Distribution.NULL_MODEL) && this.nullModelForwarder == null) {
            this.nullModelForwarder = new Distribution.NullModelForwarder(this, this.changeSupport);
            this.getNullModel().addChangeListener(this.nullModelForwarder, Distribution.WEIGHTS);
        }
    }

    public abstract Alphabet getAlphabet();

    public abstract Distribution getNullModel();

    public final double getWeight(Symbol symbol) throws IllegalSymbolException {
        if (symbol instanceof AtomicSymbol) {
            return this.getWeightImpl((AtomicSymbol)symbol);
        }
        Alphabet alphabet = symbol.getMatches();
        if (alphabet instanceof FiniteAlphabet) {
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)alphabet;
            double d = 0.0;
            double d2 = 0.0;
            Iterator iterator = finiteAlphabet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AtomicSymbol)) {
                    throw new BioError("Assertion Failure: Not an instance of AtomicSymbol: " + e);
                }
                AtomicSymbol atomicSymbol = (AtomicSymbol)e;
                double d3 = this.getNullModel().getWeight(atomicSymbol);
                d += this.getWeightImpl(atomicSymbol) * d3;
                d2 += d3;
            }
            return d == 0.0 ? 0.0 : d / d2;
        }
        throw new IllegalSymbolException("Can't find weight for infinite set of symbols matched by " + symbol.getName());
    }

    protected abstract double getWeightImpl(AtomicSymbol var1) throws IllegalSymbolException;

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        distributionTrainerContext.registerTrainer(this, IgnoreCountsTrainer.getInstance());
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public Symbol sampleSymbol() {
        double d = Math.random();
        try {
            Object object;
            Iterator iterator = ((FiniteAlphabet)this.getAlphabet()).iterator();
            while (iterator.hasNext()) {
                object = (AtomicSymbol)iterator.next();
                if (!((d -= this.getWeight((Symbol)object)) <= 0.0)) continue;
                return object;
            }
            object = new StringBuffer();
            Iterator iterator2 = ((FiniteAlphabet)this.getAlphabet()).iterator();
            while (iterator2.hasNext()) {
                AtomicSymbol atomicSymbol = (AtomicSymbol)iterator2.next();
                double d2 = this.getWeight(atomicSymbol);
                ((StringBuffer)object).append("\t" + atomicSymbol.getName() + " -> " + d2 + "\n");
            }
            throw new BioError("Could not find a symbol to emit from alphabet " + this.getAlphabet() + ". Do the probabilities sum to 1?" + "\np=" + d + "\n" + ((StringBuffer)object).toString());
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Unable to itterate over all symbols in alphabet - things changed beneath me!");
        }
    }

    public final void setNullModel(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
        if (distribution.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Could not use distribution " + distribution + " as its alphabet is " + distribution.getAlphabet().getName() + " and this distribution's alphabet is " + this.getAlphabet().getName());
        }
        Distribution distribution2 = this.getNullModel();
        if (this.nullModelForwarder != null) {
            if (distribution2 != null) {
                distribution2.removeChangeListener(this.nullModelForwarder);
            }
            distribution.addChangeListener(this.nullModelForwarder);
        }
        if (this.changeSupport == null) {
            this.setNullModelImpl(distribution);
        } else {
            ChangeEvent changeEvent = new ChangeEvent(this, Distribution.NULL_MODEL, distribution, distribution2);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.setNullModelImpl(distribution);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    protected abstract void setNullModelImpl(Distribution var1) throws IllegalAlphabetException, ChangeVetoException;

    public final void setWeight(Symbol symbol, double d) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.doSetWeight(symbol, d);
        } else {
            ChangeEvent changeEvent = new ChangeEvent(this, Distribution.WEIGHTS, new Object[]{symbol, new Double(d)}, new Object[]{symbol, new Double(this.getWeight(symbol))});
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.doSetWeight(symbol, d);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    protected abstract void setWeightImpl(AtomicSymbol var1, double var2) throws IllegalSymbolException, ChangeVetoException;
}

