/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.tree;

import com.gkano.bioinfo.tree.PhylipWriter;
import com.gkano.bioinfo.var.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Clade
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -8392803888823319176L;
    private double branchLength;
    private int bootstrapSupport = -1;

    public Clade() {
        this(null, 1.0);
    }

    public Clade(String nodeLabel, double branchLength) {
        super(nodeLabel);
        this.branchLength = branchLength;
    }

    public double getBranchLength() {
        return this.branchLength;
    }

    public void setBranchLength(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Branch length cannot be negative.");
        }
        this.branchLength = distance;
    }

    public void setBootstrapSupport(int value) {
        this.bootstrapSupport = value;
    }

    public int getBootstrapSupport() {
        return this.bootstrapSupport;
    }

    public static String cladeToString(Clade node) {
        PhylipWriter writer = new PhylipWriter();
        StringWriter sw = new StringWriter();
        writer.setOutput(sw);
        try {
            writer.write(new DefaultTreeModel(node));
        }
        catch (IOException ex) {
            Logger.error(Clade.class, ex.getMessage());
        }
        return sw.toString().replace("\n", "");
    }

    public static Set<Set<String>> extractCladesFromTree(Clade node, int totalLeaves) {
        HashSet<Set<String>> clades = new HashSet<Set<String>>();
        Clade.collectClades(node, clades, totalLeaves);
        return clades;
    }

    private static Set<String> collectClades(Clade node, Set<Set<String>> clades, int totalLeaves) {
        HashSet<String> leaves = new HashSet<String>();
        if (node.isLeaf()) {
            leaves.add(node.toString());
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Clade child = (Clade)node.getChildAt(i);
                leaves.addAll(Clade.collectClades(child, clades, totalLeaves));
            }
            if (leaves.size() > 1 && leaves.size() < totalLeaves) {
                clades.add(new HashSet<String>(leaves));
            }
        }
        return leaves;
    }

    public static void annotateTreeWithBootstrap(Clade originalTree, List<Clade> bootstrapTrees, int totalLeaves, int numBootstraps) {
        Set<Set<String>> originalClades = Clade.extractCladesFromTree(originalTree, totalLeaves);
        HashMap<Set<String>, Integer> cladeCounts = new HashMap<Set<String>, Integer>();
        for (Set<String> clade : originalClades) {
            cladeCounts.put(clade, 0);
        }
        for (Clade bootTree : bootstrapTrees) {
            Set<Set<String>> bootClades = Clade.extractCladesFromTree(bootTree, totalLeaves);
            for (Set<String> clade : originalClades) {
                if (!bootClades.contains(clade)) continue;
                cladeCounts.put(clade, (Integer)cladeCounts.get(clade) + 1);
            }
        }
        Clade.annotateCladeWithBootstrap(originalTree, cladeCounts, totalLeaves, numBootstraps);
    }

    public static Set<String> annotateCladeWithBootstrap(Clade node, Map<Set<String>, Integer> cladeCounts, int totalLeaves, int numBootstraps) {
        HashSet<String> leaves = new HashSet<String>();
        if (node.isLeaf()) {
            leaves.add(node.toString());
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Clade child = (Clade)node.getChildAt(i);
                leaves.addAll(Clade.annotateCladeWithBootstrap(child, cladeCounts, totalLeaves, numBootstraps));
            }
            if (leaves.size() > 1 && leaves.size() < totalLeaves) {
                for (Set<String> clade : cladeCounts.keySet()) {
                    if (!clade.equals(leaves)) continue;
                    int support = (int)Math.round(100.0 * (double)cladeCounts.get(clade).intValue() / (double)numBootstraps);
                    node.setBootstrapSupport(support);
                    break;
                }
            }
        }
        return leaves;
    }
}

