## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)
has_gcloud <- GCPtools::gcloud_exists()
options(width = 75)

## ----load-gcp-tools,include=TRUE,results="hide",message=FALSE,warning=FALSE----
library(GCPtools)

## ----gcloud-exists-------------------------------------------------------
gcloud_exists()

## ----gcloud_help,eval=has_gcloud-----------------------------------------
# gcloud_help() |>
#     head(10L)

## ----gcloud-access-token,eval=FALSE--------------------------------------
# gcloud_access_token("terra")

## ----gcloud-cmd,eval=has_gcloud------------------------------------------
# gcloud_cmd("version")

## ----gsutil-exists,eval=FALSE--------------------------------------------
# gsutil_exists("gs://your-bucket-name")

## ----gsutil_help,eval=has_gcloud-----------------------------------------
# gsutil_help()

## ----session-info--------------------------------------------------------
sessionInfo()

