###################################################
### chunk number 1: setup
###################################################
#line 18 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
options(width = 40)


###################################################
### chunk number 2: get the dataset
###################################################
#line 24 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
library(ALL) ## data package
library(hgu95av2.db) ## annotation package
data(ALL)
## subsetting
bcell <- grep("^B", as.character(ALL$BT))
types <- c("NEG", "BCR/ABL")
moltyp <- which(as.character(ALL$mol.biol) %in% types)
ALL_bcrneg <- ALL[, intersect(bcell, moltyp)]

ALL_bcrneg$mol.biol <- factor(ALL_bcrneg$mol.biol)

## nonspecific filtering
library(genefilter)
filt_bcrneg <- nsFilter(ALL_bcrneg, require.entrez=TRUE,
                        remove.dupEntrez=TRUE,
                        var.func=IQR,
                        var.cutoff=0.5, feature.exclude="^AFFX")
## get the real dataset
ALLfilt_bcrneg <- filt_bcrneg$eset


###################################################
### chunk number 3: load dataset eval=FALSE
###################################################
## #line 61 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
## library(SeattleIntro2010)
## data(ALLfilt_bcrneg)


###################################################
### chunk number 4: t-test
###################################################
#line 77 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
library(genefilter)
table(ALLfilt_bcrneg$mol.biol)
tt <- rowttests(ALLfilt_bcrneg, "mol.biol")


###################################################
### chunk number 5: get multtest
###################################################
#line 112 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
library(multtest)
mt <- mt.rawp2adjp(tt$p.value, proc="BH")
head(mt$adjp) ## print out the first 6 genes with their raw p and adjusted p
sum(mt$adjp[, "BH"] < 0.05)
mt$index[1:10]
featureNames(ALLfilt_bcrneg)[mt$index[1:10]]


###################################################
### chunk number 6: design matrix
###################################################
#line 131 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
library(limma)
design <- model.matrix( ~mol.biol, ALLfilt_bcrneg)
head(design)


###################################################
### chunk number 7: linear models and ebayes
###################################################
#line 145 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
fit1 <- lmFit(exprs(ALLfilt_bcrneg), design)
fit2 <- eBayes(fit1)
topTable(fit2, coef=2, adjust.method="BH", 
         number=5)


###################################################
### chunk number 8: expressed genes
###################################################
#line 162 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
result <- topTable(fit2, coef=2, adjust.method="BH", 
                   p.value=0.05, number=nrow(fit2))
nrow(result)       



###################################################
### chunk number 9: design matrix 2
###################################################
#line 172 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
design <- model.matrix( ~0+mol.biol, ALLfilt_bcrneg)
colnames(design) <- c("BCR_ABL", "NEG")
head(design)


###################################################
### chunk number 10: contrast matrix
###################################################
#line 184 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
## note that BCR_ABL and NEG are the column names of design matrix
contr <- makeContrasts(BCR_ABL-NEG, levels=design)


###################################################
### chunk number 11: simplier eval=FALSE
###################################################
## #line 188 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
## ## or simply 
## contr <- c(1, -1)


###################################################
### chunk number 12: example 2
###################################################
#line 193 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
fit <- lmFit(exprs(ALLfilt_bcrneg), design)
fit1 <- contrasts.fit(fit, contr)
fit2 <- eBayes(fit1)


###################################################
### chunk number 13: print out top 10 gene
###################################################
#line 205 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis-lab.Rnw"
topTable(fit2,  adjust.method="BH",  number=10)


