###################################################
### chunk number 1: setup
###################################################
#line 18 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
options(width = 72)
library(GenomicRanges)
library(lattice)
jnk <- capture.output(library(DESeq))


###################################################
### chunk number 2: browseVignette eval=FALSE
###################################################
## #line 50 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
## browseVignette("SeattleIntro2010")


###################################################
### chunk number 3: hitspergene
###################################################
#line 66 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
library(SeattleIntro2010)
data(hitspergene)
hitspergene[1:5,]
class(hitspergene)


###################################################
### chunk number 4: splom1
###################################################
#line 90 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
library(lattice)
df1 <- as.data.frame(hitspergene)
splom(df1, pch=".")


###################################################
### chunk number 5: splom2
###################################################
#line 95 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
df2 <- asinh(df1)
splom(df2, pch=".")


###################################################
### chunk number 6: hitspergene-reduce
###################################################
#line 120 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
elementMetadata(hitspergene)
biolReps <- elementMetadata(hitspergene)$Replicate != "Technical"
count <- hitspergene[, biolReps]

df1 <- as.data.frame(count)
hitsPerRow <- rowSums(df1)
histogram(asinh(hitsPerRow))

count <- count[hitsPerRow != 0,]
dim(count)
sum(hitsPerRow==0)  ## number of rows removed


###################################################
### chunk number 7: DESeq eval=FALSE
###################################################
## #line 143 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
## library(DESeq)
## browseVignettes("DESeq")


###################################################
### chunk number 8: newCountDataSet
###################################################
#line 171 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
df1 <- ceiling(as.data.frame(count))
sample <- elementMetadata(count)$Sample
cds <- newCountDataSet(df1, sample)


###################################################
### chunk number 9: estimateSizeFactors
###################################################
#line 188 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
cds <- estimateSizeFactors(cds)
sizeFactors(cds)
colSums(df1) / mean(colSums(df1))


###################################################
### chunk number 10: estimateVarianceFunctions
###################################################
#line 200 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
cds <- estimateVarianceFunctions(cds)


###################################################
### chunk number 11: topTable
###################################################
#line 215 "H:/SeattleIntro2010/inst/doc/Differential-Representation-lab.Rnw"
nbTopTable <- nbinomTest(cds, "dT", "RH")
head(nbTopTable, 3)
o <- order(nbTopTable$padj)
head(nbTopTable[o,], 3)


