library(SeattleIntro2010)
stopifnot(packageVersion("Rsamtools") >= package_version("1.3.11"))

datasrc <- "/home/mtmorgan/SeattleIntro2010/NagalakshmiEtAl/aln"
rng <- IRanges(1, 1e7)
which <- RangesList(chrI=rng, chrII=rng, chrIII=rng, chrIV=rng,
                    chrV=rng)

setwd(datasrc)
fls <- list.files(datasrc, pattern=".*fastq.bam$")
srt <- sub(".bam$", ".sorted", fls)
param <- ScanBamParam(which=which)
for (i in seq_along(fls)) {
    sorted <- sortBam(fls[[i]], srt[[i]])
    indexBam(sorted)
    filt <- sub(".sorted.bam$", ".filtered.bam", sorted)
    filterBam(sorted, filt, param=param)
}

