###################################################
### chunk number 1: setup
###################################################
#line 22 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
options(width = 60)
olocale=Sys.setlocale(locale="C")


###################################################
### chunk number 2: ShortReadVersion
###################################################
#line 40 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
library(ShortRead)
packageDescription("ShortRead")$Version


###################################################
### chunk number 3: embl2010 eval=FALSE
###################################################
## #line 56 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
## library(SeattleIntro2010)


###################################################
### chunk number 4: extdataDir
###################################################
#line 81 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
extdataDir <- 
    system.file("extdata", package="SeattleIntro2010")
file.exists(extdataDir)
stopifnot(file.exists(extdataDir))


###################################################
### chunk number 5: filePattern
###################################################
#line 99 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
list.files(extdataDir)


###################################################
### chunk number 6: pattern
###################################################
#line 115 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
pattern <- "SRR002051.chrI-V.bam$"
list.files(extdataDir, pattern)


###################################################
### chunk number 7: readAligned
###################################################
#line 132 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
aln <- readAligned(extdataDir, pattern, type="BAM")


###################################################
### chunk number 8: aln
###################################################
#line 147 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
aln


###################################################
### chunk number 9: aln-head
###################################################
#line 155 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
head(sread(aln))
table(strand(aln), useNA="ifany")
table(chromosome(aln), useNA="ifany")


###################################################
### chunk number 10: alphabetFreqeuncy
###################################################
#line 190 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
alphabetFrequency(sread(aln), collapse=TRUE, baseOnly=TRUE, 
                  as.prob=TRUE)


###################################################
### chunk number 11: abc-lab-plot
###################################################
#line 207 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
abc <- alphabetByCycle(sread(aln))
dim(abc)
abc[1:4,1:5]
matplot(t(abc[1:4,]), type="l", lty=c(1:4), 
col=c("green","red","black","blue"), xlab="Cycle", ylab="Count")
legend("top", dimnames(abc)$alphabet[1:4], lty=c(1:4), 
col=c("green","red","black","blue"), bty="n", horiz=T)


###################################################
### chunk number 12: quality
###################################################
#line 230 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
head(quality(aln))


###################################################
### chunk number 13: quality-scores
###################################################
#line 244 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
alf <- alphabet(quality(aln))
m <- as(quality(aln), "matrix")
colMeans(m)


###################################################
### chunk number 14: gcRegions
###################################################
#line 255 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
res <- alphabetFrequency(sread(aln), baseOnly=TRUE)
head(res)
gcContent <- rowSums(res[,c("G", "C")]) / rowSums(res)
print(histogram(gcContent, xlab="Percent GC", 
                ylab="Percent of total reads"))
gcIdx <- gcContent > 0.6
aln[gcIdx]


###################################################
### chunk number 15: alignQuality
###################################################
#line 283 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
alignQuality(aln)
q <- quality(alignQuality(aln))
sum(q==0)
print(densityplot(q[q>1], plot.points=FALSE, 
                  xlab="Alignment quality"))


###################################################
### chunk number 16: select
###################################################
#line 313 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
chrfilt <- chromosomeFilter("chrIII|chrV") 
aln[chrfilt(aln)]


###################################################
### chunk number 17: sampleFunction
###################################################
#line 330 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
samplingFilter <- function(sampleSize) {
    srFilter(function(x) {
        idx <- seq_len(length(x))
        idx %in% sample(idx, sampleSize)
    }, name="Demo sampling filter")
}
sample100 <- samplingFilter(100)
aln[sample100(aln)]


###################################################
### chunk number 18: qa-input
###################################################
#line 409 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
data("qa", package="SeattleIntro2010")
names(qa)


###################################################
### chunk number 19: qa-laneinfo
###################################################
#line 423 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
data("hitspergene", package="SeattleIntro2010")
elementMetadata(hitspergene)


###################################################
### chunk number 20: qa-report
###################################################
#line 437 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
rpt <- report(qa, dest=tempfile())


###################################################
### chunk number 21: qa-browse eval=FALSE
###################################################
## #line 442 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
## browseURL(rpt) 


###################################################
### chunk number 22: sessionInfo
###################################################
#line 456 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis-lab.Rnw"
toLatex(sessionInfo())


