###################################################
### chunk number 1: setup
###################################################
#line 25 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
options(width = 64)
library(GenomicRanges)
library(Biostrings)
library(SeattleIntro2010)
plotGRanges <- function(x, main = deparse(substitute(x)), sep = 0.5, ...) 
{
  height <- 1
  bins <- disjointBins(IRanges(start(x), end(x) + 1))
  plot.new()
  plot.window(c(0, 50), c(0, max(bins)*(height + sep)))
  ybottom <- bins * (sep + height) - height
  col <- ifelse(as.vector(strand(x) == "+"), "blue",
         ifelse(as.vector(strand(x) == "-"), "red", "purple"))
  rect(start(x) - 0.5, ybottom, end(x) + 0.5, ybottom + height, col = col, ...)
  title(main)
  axis(1)
}


###################################################
### chunk number 2: naive-GRanges-1
###################################################
#line 182 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
chr <- c("chr1", "chr2", "chr1")
strand <- c("+", "+", "-")
start <- c(3L, 4L, 1L)
end <- c(7L, 5L, 3L)
naive <- data.frame(chr = chr, strand = strand,
                    start = start, end = end)


###################################################
### chunk number 3: GRanges-construction
###################################################
#line 211 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
bioc <- GRanges(seqnames = chr,
                ranges = IRanges(start = start, end = end),
                strand = strand,
                seqlengths = c(chr1 = 24, chr2 = 18))


###################################################
### chunk number 4: GRanges-display
###################################################
#line 225 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
bioc


###################################################
### chunk number 5: ranges-construct
###################################################
#line 257 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
ir <- IRanges(c(1, 8, 14, 15, 19, 34, 40), 
              width=c(12, 6,  6, 15, 6, 2, 7))
strand <- rep(c("+", "-"), c(4, 3))
gr <- GRanges(seqnames = "chr1", ranges = ir, strand = strand,
              seqlengths = c(chr1 = 50))
gr


###################################################
### chunk number 6: ranges-plot
###################################################
#line 271 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(gr)


###################################################
### chunk number 7: ranges-reduce-plot
###################################################
#line 275 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(reduce(gr))


###################################################
### chunk number 8: ranges-gaps-plot
###################################################
#line 279 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(gaps(gr))


###################################################
### chunk number 9: ranges-subset
###################################################
#line 292 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
gr[strand(gr) == "-"]


###################################################
### chunk number 10: ranges-overlap
###################################################
#line 307 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
ol <- findOverlaps(gr, reduce(gr))
as.matrix(ol)
countOverlaps(reduce(gr), gr)


###################################################
### chunk number 11: ranges-coverage
###################################################
#line 326 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
cvg <- coverage(gr)


###################################################
### chunk number 12: ranges-coverage-plot
###################################################
#line 330 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
cvg <- coverage(gr)
plotGRanges(gr, main="coverage(gr)")
cvg <- as.integer(cvg[["chr1"]])
mat <- cbind(seq_along(cvg)-0.5, cvg)
d <- diff(cvg) != 0
mat <- rbind(cbind(mat[d,1]+1, mat[d,2]), mat)
mat <- mat[order(mat[,1]),]
lines(mat, col="black", lwd=4)
axis(2)


###################################################
### chunk number 13: DNAString
###################################################
#line 352 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
library(Biostrings)
data(yeastSEQCHR1)
c(class(yeastSEQCHR1), nchar(yeastSEQCHR1))
yeast1 <- DNAString(yeastSEQCHR1)
yeast1
IUPAC_CODE_MAP
data(srPhiX174)
length(srPhiX174)
head(srPhiX174, 3)


###################################################
### chunk number 14: alphabetFrequency
###################################################
#line 431 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
alphabetFrequency(yeast1, baseOnly=TRUE)


###################################################
### chunk number 15: dinucleotideFrequency
###################################################
#line 439 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
dinucleotideFrequency(yeast1)
head(trinucleotideFrequency(yeast1), 12)


###################################################
### chunk number 16: consensusMatrix
###################################################
#line 470 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
snippet <- subseq(head(sort(srPhiX174), 5), 1, 10)
consensusMatrix(snippet, baseOnly=TRUE)


###################################################
### chunk number 17: consensusString
###################################################
#line 479 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
consensusString(snippet)
consensusString(snippet, ambiguityMap = "N", threshold = 0.5)


###################################################
### chunk number 18: countPDict
###################################################
#line 491 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(phiX174Phage)
genome <- phiX174Phage[["NEB03"]]
negPhiX174 <- reverseComplement(srPhiX174)
posCounts <- countPDict(PDict(srPhiX174), genome)
negCounts <- countPDict(PDict(negPhiX174), genome)
table(posCounts, negCounts)


###################################################
### chunk number 19: matchPDict
###################################################
#line 504 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
matchPDict(PDict(srPhiX174[posCounts > 0]), genome)


###################################################
### chunk number 20: pairwiseAlignments-1
###################################################
#line 515 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(phiX174Phage)
posScore <- pairwiseAlignment(srPhiX174, genome,
              type = "global-local", scoreOnly = TRUE)
negScore <- pairwiseAlignment(negPhiX174, genome,
              type = "global-local", scoreOnly = TRUE)
cutoff <- max(pmin.int(posScore, negScore))


###################################################
### chunk number 21: matchPDict
###################################################
#line 528 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
pairwiseAlignment(srPhiX174[posScore > cutoff], genome,
                  type = "global-local")


###################################################
### chunk number 22: available.genomes
###################################################
#line 559 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
library(BSgenome)
available.genomes()


