###################################################
### chunk number 1: setup
###################################################
#line 25 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
options(width = 64)
library(GenomicRanges)
library(Biostrings)
library(SeattleIntro2010)
plotGRanges <- function(x, xlim = x, main = deparse(substitute(x)),
                       sep = 0.5, ...) 
{
  height <- 1
  if (is(xlim, "Ranges") || is(xlim, "GRanges"))
    xlim <- c(min(start(xlim)), max(end(xlim)))
  bins <- disjointBins(IRanges(start(x), end(x) + 1))
  plot.new()
  plot.window(xlim, c(0, max(bins)*(height + sep)))
  ybottom <- bins * (sep + height) - height
  col <- ifelse(as.vector(strand(x) == "+"), "blue",
         ifelse(as.vector(strand(x) == "-"), "red", "purple"))
  rect(start(x) - 0.5, ybottom, end(x) + 0.5, ybottom + height, col = col, ...)
  title(main)
  axis(1)
}


###################################################
### chunk number 2: naive-GRanges-1
###################################################
#line 187 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
chr <- c("chr1", "chr2", "chr1")
strand <- c("+", "+", "-")
start <- c(3L, 4L, 1L)
end <- c(7L, 5L, 3L)
naive <- data.frame(chr = chr, strand = strand,
                    start = start, end = end)


###################################################
### chunk number 3: GRanges-construction
###################################################
#line 230 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
bioc <- GRanges(seqnames = chr,
                ranges = IRanges(start = start, end = end),
                strand = strand,
                seqlengths = c("chr1" = 24, "chr2" = 18))


###################################################
### chunk number 4: GRanges-display
###################################################
#line 244 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
bioc


###################################################
### chunk number 5: GRanges-slots
###################################################
#line 262 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
getSlots("GRanges")


###################################################
### chunk number 6: ranges-construct
###################################################
#line 315 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
ir <- IRanges(c(1, 8, 14, 15, 19, 34, 40), 
              width=c(12, 6,  6, 15, 6, 2, 7))
strand <- rep(c("+", "-"), c(4,3))
grngs <- GRanges(seqnames = "chr1", ranges = ir,
                 strand = strand,
                 seqlengths = c("chr1" = 50))


###################################################
### chunk number 7: ranges-plot
###################################################
#line 324 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(grngs)


###################################################
### chunk number 8: ranges-subset
###################################################
#line 338 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
seqselect(grngs, strand(grngs) == "-")


###################################################
### chunk number 9: ranges-shift
###################################################
#line 356 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
shift(grngs, 1)


###################################################
### chunk number 10: ranges-resize-1
###################################################
#line 368 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
resize(grngs, 10)


###################################################
### chunk number 11: ranges-reduce-plot
###################################################
#line 377 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(reduce(grngs))


###################################################
### chunk number 12: ranges-gaps-plot
###################################################
#line 381 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(gaps(grngs))


###################################################
### chunk number 13: ranges-disjoin-plot
###################################################
#line 385 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotGRanges(disjoin(grngs))


###################################################
### chunk number 14: ranges-overlap
###################################################
#line 398 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
ol <- findOverlaps(grngs, reduce(grngs))
as.matrix(ol)
countOverlaps(reduce(grngs), grngs)


###################################################
### chunk number 15: ranges-coverage
###################################################
#line 416 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
cover <- coverage(grngs)


###################################################
### chunk number 16: ranges-coverage-plot
###################################################
#line 420 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
cover <- coverage(grngs)
plotGRanges(grngs)
cover <- as.integer(cover[["chr1"]])
mat <- cbind(seq_along(cover)-0.5, cover)
d <- diff(cover) != 0
mat <- rbind(cbind(mat[d,1]+1, mat[d,2]), mat)
mat <- mat[order(mat[,1]),]
lines(mat, col="black", lwd=4)
axis(2)


###################################################
### chunk number 17: coverage-data-1
###################################################
#line 531 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(SRR002051.pluscvg)
data(SRR002051.minuscvg)


###################################################
### chunk number 18: coverage-data-2
###################################################
#line 536 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
c(class(SRR002051.pluscvg), class(SRR002051.minuscvg))
SRR002051.pluscvg[["chrI"]]
SRR002051.minuscvg[["chrI"]]
SRR002051.pluscvg[["chrI"]] + SRR002051.minuscvg[["chrI"]]


###################################################
### chunk number 19: plotCoverage
###################################################
#line 549 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverage <-
function(x, chrom, start=1, end=length(x[[chrom]]), col="blue",
         xlab="Index", ylab="Coverage", main=chrom)
{
    xWindow <- as.vector(window(x[[chrom]], start, end))
    x <- start:end
    xlim <- c(start, end)
    ylim <- c(0, max(xWindow))
    plot(x = start, y = 0, xlim = xlim, ylim = ylim,
         xlab = xlab, ylab = ylab, main = main, type = "n")
    polygon(c(start, x, end), c(0, xWindow, 0), col = col)
}


###################################################
### chunk number 20: cover-all-chr1-pos
###################################################
#line 571 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverage(SRR002051.pluscvg, "chrI")


###################################################
### chunk number 21: plotCoverage
###################################################
#line 586 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverageStrands <-
function(pos, neg, chrom, start=1,
         end=max(length(pos[[chrom]]), length(neg[[chrom]])),
         pos.col="blue", neg.col="red", xlab="Index",
         ylab="Coverage", main=chrom)
{
    pos1 <- pos[[chrom]]
    neg1 <- neg[[chrom]]
    if (length(pos1) < end)
        pos1 <- c(pos1, Rle(0L, end - length(pos1)))
    if (length(neg1) < end)
        neg1 <- c(neg1, Rle(0L, end - length(neg1)))
    posWindow <- as.vector(window(pos1, start, end))
    negWindow <- as.vector(window(neg1, start, end))
    x <- start:end
    xlim <- c(start, end)
    ylim <- c(-1, 1) * min(max(posWindow), max(negWindow))
    plot(x = start, y = 0, xlim = xlim, ylim = ylim,
         xlab = xlab, ylab = ylab, main = main, type = "n")
    polygon(c(start, x, end), c(0, posWindow, 0), col = pos.col)
    polygon(c(start, x, end), c(0, - negWindow, 0), col = neg.col)
}


###################################################
### chunk number 22: cover-all-chr1
###################################################
#line 618 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverageStrands(SRR002051.pluscvg, SRR002051.minuscvg, "chrI")


###################################################
### chunk number 23: cover-window-chr1
###################################################
#line 633 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverageStrands(SRR002051.pluscvg, SRR002051.minuscvg, "chrI", 135000, 145000)


###################################################
### chunk number 24: cover-smooth-chr1
###################################################
#line 648 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
posSmoothCover <- round(runmean(SRR002051.pluscvg, 75, endrule = "constant"))
negSmoothCover <- round(runmean(SRR002051.minuscvg, 75, endrule = "constant"))
plotCoverageStrands(posSmoothCover,negSmoothCover,"chrI",135000,145000)


###################################################
### chunk number 25: combined-coverage
###################################################
#line 665 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
combSmoothCover <- mendoapply(pmin,
                              posSmoothCover,
                              negSmoothCover)
identical(class(posSmoothCover), class(combSmoothCover))


###################################################
### chunk number 26: cover-comb-chr1
###################################################
#line 691 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
plotCoverage(combSmoothCover, "chrI", 135000, 145000)


###################################################
### chunk number 27: slice
###################################################
#line 705 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
islands <- slice(combSmoothCover, lower=1)
islandsWithWidePeaks <- islands[viewMaxs(islands) >= 8L &
                                width(islands) >= 500L]
islandsWithWidePeaks


###################################################
### chunk number 28: XString-subclasses
###################################################
#line 735 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
library(Biostrings)
names(completeSubclasses(getClass("XString")))


###################################################
### chunk number 29: DNAString
###################################################
#line 744 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(yeastSEQCHR1)
c(class(yeastSEQCHR1), nchar(yeastSEQCHR1))
yeast1 <- DNAString(yeastSEQCHR1)
yeast1
IUPAC_CODE_MAP


###################################################
### chunk number 30: XStringSet-subclasses
###################################################
#line 759 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
head(names(completeSubclasses(getClass("XStringSet"))), 4)


###################################################
### chunk number 31: DNAString
###################################################
#line 767 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(srPhiX174)
length(srPhiX174)
head(srPhiX174, 3)


###################################################
### chunk number 32: GRanges-slots
###################################################
#line 780 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
getSlots("XString")
getSlots("XStringSet")


###################################################
### chunk number 33: alphabetFrequency
###################################################
#line 867 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
alphabetFrequency(yeast1, baseOnly=TRUE)


###################################################
### chunk number 34: dinucleotideFrequency
###################################################
#line 875 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
dinucleotideFrequency(yeast1)
head(trinucleotideFrequency(yeast1), 12)


###################################################
### chunk number 35: consensusMatrix
###################################################
#line 921 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
snippet <- subseq(head(sort(srPhiX174), 5), 1, 10)
consensusMatrix(snippet, baseOnly=TRUE)


###################################################
### chunk number 36: consensusString
###################################################
#line 930 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
consensusString(snippet)
consensusString(snippet, ambiguityMap = "N", threshold = 0.5)


###################################################
### chunk number 37: matchPDict
###################################################
#line 942 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(phiX174Phage)
genome <- phiX174Phage[["NEB03"]]
negPhiX174 <- reverseComplement(srPhiX174)
posCounts <- countPDict(PDict(srPhiX174), genome)
negCounts <- countPDict(PDict(negPhiX174), genome)
table(posCounts, negCounts)


###################################################
### chunk number 38: matchPDict
###################################################
#line 955 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
matchPDict(PDict(srPhiX174[posCounts > 0]), genome)


###################################################
### chunk number 39: pairwiseAlignments-1
###################################################
#line 966 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
data(phiX174Phage)
posScore <- pairwiseAlignment(srPhiX174, genome,
              type = "global-local", scoreOnly = TRUE)
negScore <- pairwiseAlignment(negPhiX174, genome,
              type = "global-local", scoreOnly = TRUE)
cutoff <- max(pmin.int(posScore, negScore))


###################################################
### chunk number 40: matchPDict
###################################################
#line 979 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges.Rnw"
pairwiseAlignment(srPhiX174[posScore > cutoff], genome,
                  type = "global-local")


