.ncols <- 113735

fname0 <- system.file("extdata", "snpData.csv",
                      package="AdvancedR2011Data")

f0 <- function(fileName, nrows=5, ...) {
    read.csv(fileName, nrows=nrows, row.names=NULL,
             header=FALSE, ...)
}

f1 <- function(fileName, nrows=5, ncols=.ncols, keep=1:100, ...) {
    colClasses <- rep("NULL", ncols)
    colClasses[keep] <- "integer"
    f0(fileName, nrows=nrows, colClasses=colClasses, ...)
}

f2 <- function(fileName, nrows=5, ncols=.ncols, keep=1:100, ...) {
    what <- rep(list(NULL), ncols)
    what[keep] <- list(integer())
    input <- scan(fileName, what=what, sep=",", nmax=nrows, ...,
                  quiet=TRUE)
    df <- as.data.frame(Filter(is.integer, input))
    names(df) <- paste("V", keep, sep="")
    df
}

shuffle0 <- function(genotypes, seed=123L) {
    set.seed(seed)
    samp <- sample(genotypes)
    g <- unlist(samp)
    matrix(g, ncol=ncol(genotypes))
}

shuffle1 <- function(genotypes, seed=123L) {
    set.seed(seed)
    samp <- sample(genotypes)
    g <- unlist(samp, use.names=FALSE)
    matrix(g, ncol=ncol(genotypes))
}

shuffle2 <- function(genotypes, seed=123L) {
    set.seed(seed)
    as.matrix(sample(genotypes))
}

.fapply <-
    function(con, FUN, ..., .get, .reduce)
{
    result <- list()
    it <- 1
    while(nrow(chunk <- .get(con)))
    {
        message("chunk ", it)
        result[[it]] <- FUN(chunk, ...)
        it <- it + 1
    }
    .reduce(result)
}
