###################################################
### chunk number 1: setup
###################################################
#line 17 "e:/packagebuilder/jobs/AdvancedR2011_20110307093955/AdvancedR2011/inst/doc/CourseIntroduction.Rnw"
options(width = 40)
library(ggplot2)


###################################################
### chunk number 2: 
###################################################
#line 88 "e:/packagebuilder/jobs/AdvancedR2011_20110307093955/AdvancedR2011/inst/doc/CourseIntroduction.Rnw"

set.seed(123)
p <- 0.9
Snp1 <- factor(sample(c("AA", "AC", "CC"), 1000, TRUE,
                      c(p^2, 2*p*(1-p), (1-p)^2)))
Score <- as.integer(Snp1) + rnorm(length(Snp1))
Status <- factor(ifelse(Score > 1, "Case", "Control"),
                 levels=c("Control", "Case"))
df0 <- data.frame(Snp1=Snp1, Score=Score, Status=Status)
df <- as.data.frame(xtabs(~Status+Snp1, df0))

print(ggplot(df, aes(Snp1, Status)) + 
    geom_point(aes(size=Freq), legend=FALSE) + 
    scale_area(to=c(1, 25), legend=FALSE) +
    xlab("    SNP 1") +
    opts(axis.title.x=theme_text(size=30),
         axis.text.y=theme_text(colour = "grey50", 
           size = 10, hjust = .5, lineheight = 0.9, angle=90),
         axis.title.y=theme_text(size=30, angle=90)))


