###################################################
### chunk number 1: setup
###################################################
options(width = 40)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## ## attaching packages
## library(flowCore)


###################################################
### chunk number 3: biocLite eval=FALSE
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("flowCore")


###################################################
### chunk number 4: flowTrack eval=FALSE
###################################################
## pkg <- "myDir/flowTrack_1.0.0.tar.gz"
## install.packages(pkg, repos=NULL, type="source")


###################################################
### chunk number 5: vector
###################################################
# numeric
L <- c(1.2, 4.3, 2.3, 4)
W <- c(13.8, 22.4, 18, 18.9) 
# most of functions are vectorized
length(L)
area <- L * W 
area


###################################################
### chunk number 6: basic data types
###################################################
s <- "a string" # character
t <- TRUE # logical
i <- 1L # integer
i <- 1+1i # complex



###################################################
### chunk number 7: functions
###################################################
1:10
rep(1:2, 3)


###################################################
### chunk number 8: naming
###################################################
## name the elements of a vector
v <- c(a=1.1, b=2, c=100, d=50, e=60)
v


###################################################
### chunk number 9: 
###################################################
v[c(1,3,4)]


###################################################
### chunk number 10: 
###################################################
v[-c(1:3)] # exclude elements


###################################################
### chunk number 11: matrix
###################################################
x <- matrix(1:25, ncol=5, dimnames=list(letters[1:5], 
                            LETTERS[1:5]))
x
x[, 2]            


###################################################
### chunk number 12: data.frame
###################################################
df <- data.frame(type=c("case", "case", 
                "control", "control"), time=rexp(4))
df
df$time
names(df)



###################################################
### chunk number 13: list
###################################################
lst <- list(a=1:4, b=c("X", "Y"), 
            uspaper=list(length=11, width=8.5))
lst


###################################################
### chunk number 14: subset 1
###################################################
lst[[1]]


###################################################
### chunk number 15: subset 2
###################################################
lst[1]


###################################################
### chunk number 16: subset 3
###################################################
lst[["b"]]


###################################################
### chunk number 17: hello world
###################################################
say <- function(name, greeting="hello") 
{
  paste(greeting, name)
}
say("world")


###################################################
### chunk number 18: flowFrame
###################################################
library(flowCore)
data(GvHD)
class(GvHD)
GvHD
GvHD[1]
f <- GvHD[[1]]
f


###################################################
### chunk number 19: methods
###################################################
f[, "FSC-H"]


###################################################
### chunk number 20: exprs
###################################################
head(exprs(f))


###################################################
### chunk number 21: keywords
###################################################
keyword(f, "FILENAME")


###################################################
### chunk number 22: plotflowFrame eval=FALSE
###################################################
## library(flowViz)
## xyplot(`FSC-H` ~ `SSC-H`, f)


###################################################
### chunk number 23: pData flowSet
###################################################
head(pData(phenoData(GvHD)))


###################################################
### chunk number 24: fsApply
###################################################
## loop over a flowset to get the range for the 
## first three flowFrames
fsApply(GvHD[1:3], range)


