###################################################
### chunk number 1: load-pkg
###################################################
library(EfficientR)


###################################################
### chunk number 2: scripts
###################################################
fl <- system.file("script", "pitfalls.R", 
                  package="EfficientR")
source(fl)


###################################################
### chunk number 3: fname
###################################################
fname0 <- system.file("extdata", "gwas_2.csv", 
                      package="EfficientR")
f0
gwas1 <- f0(fname0)


###################################################
### chunk number 4: system.time-f0
###################################################
system.time(gwas0 <-  f0(fname0))
dim(gwas0)


###################################################
### chunk number 5: f12
###################################################
f1
f2


###################################################
### chunk number 6: system.time-f12
###################################################
system.time(gwas1 <- f1(fname0))
system.time(gwas2 <- f2(fname0))


###################################################
### chunk number 7: object.size
###################################################
object.size(gwas0)
object.size(gwas1)


###################################################
### chunk number 8: identical-f12
###################################################
identical(gwas1, gwas2)    


###################################################
### chunk number 9: xtabs
###################################################
xtabs(~CaseControl + Sex, gwas2)


###################################################
### chunk number 10: gtype
###################################################
gtype <- gwas0[,-(1:3)]
names(gtype) <- paste("snp", names(gtype), sep="_")
head(gtype[,1:4])


###################################################
### chunk number 11: shuffle0
###################################################
shuffle0


###################################################
### chunk number 12: system.time-shuffl0
###################################################
system.time(s0 <- shuffle0(gtype))


###################################################
### chunk number 13: profile
###################################################
profFile <- tempfile()
Rprof(profFile)      # start gathering profile information
s0 <- shuffle0(gtype)
Rprof()              # stop
head(summaryRprof(profFile)$by.self)


###################################################
### chunk number 14: unlist
###################################################
gsubset <- gtype[1:2, 1:3]
unlist(gsubset)


###################################################
### chunk number 15: shuffle1
###################################################
shuffle1


###################################################
### chunk number 16: system.time-shuffle1
###################################################
system.time(s1 <- shuffle1(gtype))
identical(s0, s1)


###################################################
### chunk number 17: shuffle2
###################################################
shuffle2
system.time(s2 <- shuffle2(gtype))


###################################################
### chunk number 18: identical-s12
###################################################
identical(s1, s2)


###################################################
### chunk number 19: all.equal
###################################################
all.equal(s1, s2)
all.equal(s1, s2, check.attributes=FALSE)


###################################################
### chunk number 20: snp0
###################################################
snp0
snp0(1, gwas0)


###################################################
### chunk number 21: system.time-snp
###################################################
system.time(result <- lapply(1:10, snp0, gwas0))


###################################################
### chunk number 22: fapply
###################################################
readScript("fapply.R")
fl <- system.file("script", "fapply.R",
                  package="EfficientR")
source(fl)


###################################################
### chunk number 23: hetero
###################################################
hetero <- function(chunk, ...) {
  cat("starting chunk\n")
  rowSums(chunk[,-(1:3)]=="AB") / (ncol(chunk) - 3)
}


###################################################
### chunk number 24: fapply-try
###################################################
res <- fapply.csv(fname0, hetero, row.names=1, .reduce=unlist)
length(res)


###################################################
### chunk number 25: fapply-densityplot
###################################################
library(lattice)
print(densityplot(res, plot.points=FALSE, xlab="Heterozygosity", 
                  main="Stream"))


###################################################
### chunk number 26: sqllite
###################################################
library(RSQLite)
db0 <- sub("csv$", "sql", fname0) # $
drv <- dbDriver("SQLite")
conn <- dbConnect(drv, dbname=db0)
dbListTables(conn)


###################################################
### chunk number 27: sqlite-df
###################################################
q <- dbSendQuery(conn, "SELECT * FROM gwasPhenotypes")
df <- fetch(q, n=-1)
clear <- dbClearResult(q)
head(df)


###################################################
### chunk number 28: orig-data
###################################################
gwasPhenotype <- f2(fname0)


###################################################
### chunk number 29: sql-table
###################################################
df1 <- dbGetQuery(conn, "SELECT * FROM gwasPhenotypes")
df2 <- dbReadTable(conn, "gwasPhenotypes")


###################################################
### chunk number 30: sql-which
###################################################
df <- dbGetQuery(conn, 
                 "SELECT age FROM gwasPhenotypes 
                  WHERE sex = 'F'")


###################################################
### chunk number 31: sql-count
###################################################
dbGetQuery(conn,
           "SELECT COUNT(*) FROM gwasPhenotypes 
            WHERE age > 40 AND sex = 'F'")


###################################################
### chunk number 32: sql-tidy
###################################################
ok <- dbDisconnect(conn)


###################################################
### chunk number 33: ncdf
###################################################
ncdf0 <- sub("csv$", "nc", fname0) #$
library(ncdf)
nc <- open.ncdf(ncdf0)
nc


###################################################
### chunk number 34: ncdf-discovery
###################################################
names(nc)
names(nc[["dim"]])
names(nc[["dim"]][["SNP"]])
nSnps <- nc[["dim"]][["SNP"]][["len"]]


###################################################
### chunk number 35: ncdf-first-get
###################################################
g <- get.var.ncdf(nc, "Genotype", start=c(1, 1), count=c(10, nSnps))


###################################################
### chunk number 36: ncdf-tidy
###################################################
ok <- close(nc)    


###################################################
### chunk number 37: spawn
###################################################
readScript("spawn.R")


###################################################
### chunk number 38: snp0-script
###################################################
readScript("snp0.R")


###################################################
### chunk number 39: snp2-script
###################################################
readScript("snp2.R")


###################################################
### chunk number 40: ncdf-mpi eval=FALSE
###################################################
## nSamples <- 1000
## nWorkers <- 2
## ## divide samples between workers; .splitIndices in Rmpi
## library(Rmpi)
## idx <- lapply(.splitIndices(nSamples, nWorkers), range)
## ## calculate individual heterozygosity for samples in idxElt
## nchetero <- function(idxElt, ...)
## {
##     snpN <- nc[["dim"]][["SNP"]][["len"]]
##     start <- c(idxElt[1], 1)
##     count <- c(diff(idxElt) + 1L, snpN)
##     d <- get.var.ncdf(nc, "Genotype", start=start, count=count)
##     rowSums(d==2) / ncol(d)
## }
## 
## mpi.spawn.Rslaves(nsl=nWorkers)
## mpi.bcast.cmd(library(ncdf))
## mpi.bcast.Robj2slave(ncdf0)
## mpi.bcast.cmd(nc <- open.ncdf(ncdf0))
## res <- mpi.parLapply(idx, nchetero)
## mpi.bcast.cmd(close(nc))
## ok <- mpi.close.Rslaves()


###################################################
### chunk number 41: mpi-densityplot eval=FALSE
###################################################
## densityplot(unlist(res), plot.points=FALSE, xlab="Heterozygosity", 
##             main="MPI and NetCDF")


