###################################################
### chunk number 1: setup
###################################################
#line 43 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
options(width=60)
olocale = Sys.setlocale(locale="C")
vers <- R.Version()
vers <- paste(vers$major, vers$minor, sep = ".")


###################################################
### chunk number 2: readData
###################################################
#line 105 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
library(SeattleIntro2010)
phenoPath <- system.file( "extdata", "pData.csv", package="SeattleIntro2010") 
pdOrig <- read.table(phenoPath, check.names = FALSE)
colnames(pdOrig)
expPath <- system.file("extdata", "exprsMat.csv", package="SeattleIntro2010") 
expOrig <- read.table(expPath, check.names = FALSE)


###################################################
### chunk number 3: subsetPhenoData
###################################################
#line 163 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
bcell <- grep("^B", as.character(pdOrig$BT))
types <- c("NEG", "BCR/ABL")
moltyp <- which(as.character(pdOrig[["mol biol"]]) %in% types)
indx <- intersect(bcell, moltyp)
psubData <- pdOrig[indx,]
exprsMat <- expOrig[, indx]


###################################################
### chunk number 4: recodeFactors
###################################################
#line 193 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
psubData$BT <-  factor(psubData$BT)
levels(psubData$BT)
psubData[["mol biol"]] <- factor(psubData[["mol biol"]])
levels(psubData[["mol biol"]])


###################################################
### chunk number 5: contingencytables
###################################################
#line 272 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"

aggregate( psubData[, "age", drop = FALSE], by= list("sex"= psubData$sex,
            "molBiol"= psubData[["mol biol"]]),  FUN = mean,
        na.rm = TRUE )
aggregate(age ~ sex + `mol biol`, data = psubData, FUN = mean)

xtabs( relapse ~ sex + `mol biol`, data = psubData)


###################################################
### chunk number 6: xyplotFormula eval=FALSE
###################################################
## #line 288 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
## xyplot(y ~ x | c, data, groups = g)


###################################################
### chunk number 7: lattice plots
###################################################
#line 357 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
library(lattice)
mat <- exprsMat[,1:20]
A <- rowMeans(log2(mat))
M <- log2(unlist(mat)) - A
Sample <- rep(colnames(mat), each=nrow(mat))
df <- data.frame(M, A, Sample, row.names=NULL, check.names = FALSE)
plt <-  xyplot(M ~ A | Sample, df, panel=panel.smoothScatter)



###################################################
### chunk number 8: xyPlotPrint
###################################################
#line 369 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
print(plt)


###################################################
### chunk number 9: sessionInfo
###################################################
#line 381 "H:/SeattleIntro2010/inst/doc/IntroToR_Lab.Rnw"
toLatex(sessionInfo())


