###################################################
### chunk number 1: setup
###################################################
#line 19 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges-lab.Rnw"
options(width = 60)
library(GenomicFeatures)
library(BSgenome.Scerevisiae.UCSC.sacCer2)
library(SeattleIntro2010)


###################################################
### chunk number 2: preliminaries eval=FALSE
###################################################
## #line 39 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges-lab.Rnw"
## source("http://bioconductor.org/course-packages/install-SeattleIntro2010.R")


###################################################
### chunk number 3: importance-of-preprocessing-setup
###################################################
#line 589 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges-lab.Rnw"
library(SeattleIntro2010)
library(Biostrings)
filepath <- system.file("extdata", "SRR002051.reads1-50k.fastq", package="SeattleIntro2010")
reads <- read.DNAStringSet(filepath, format="fastq")
cleanreads <- reads[alphabetFrequency(reads, baseOnly=TRUE)[ , "other"] == 0L]
library(BSgenome.Scerevisiae.UCSC.sacCer2)


###################################################
### chunk number 4: importance-of-preprocessing
###################################################
#line 598 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges-lab.Rnw"
system.time(nhits <- countPDict(cleanreads, Scerevisiae$chrI))
system.time(nhits2 <- countPDict(PDict(cleanreads), Scerevisiae$chrI))
identical(nhits, nhits2)
table(nhits)


###################################################
### chunk number 5: sessionInfo
###################################################
#line 844 "H:/SeattleIntro2010/inst/doc/DNAStringsAndRanges-lab.Rnw"
toLatex(sessionInfo())


