###################################################
### chunk number 1: setup
###################################################
#line 22 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
options(width = 40)


###################################################
### chunk number 2: library
###################################################
#line 144 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
library(SeattleIntro2010)
library(ShortRead)
fl <- system.file("extdata", "SRR002051.chrI-V.bam",
  package="SeattleIntro2010") 
aln <- readAligned(fl, type = "BAM")


###################################################
### chunk number 3: aln
###################################################
#line 155 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
aln
table(strand(aln), useNA="always")


###################################################
### chunk number 4: sread
###################################################
#line 163 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
head(sread(aln), 3) 


###################################################
### chunk number 5: abc
###################################################
#line 171 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
alnp <- aln[strand(aln) == "+"]
abc <- alphabetByCycle(sread(alnp))
class(abc)
abc[1:6,1:4]


###################################################
### chunk number 6: abc-plot
###################################################
#line 185 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
tabc <- t(abc[1:4,])
matplot(tabc, type="l",
        lty=rep(1, 4))


###################################################
### chunk number 7: quality-plot
###################################################
#line 202 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
m <- as(quality(alnp), 
        "matrix")
plot(colMeans(m), type="b")


###################################################
### chunk number 8: chr-recode
###################################################
#line 222 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
chrom <- chromosome(alnp)
i <- sub("S288C_([[:digit:]]+)", "\\1", levels(chrom))
levels(chrom) <- paste("chr", as.roman(i), sep="")
alnp <- renew(alnp, chromosome=chrom)


###################################################
### chunk number 9: scanBam-2 eval=FALSE
###################################################
## #line 286 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
## ## reads on chr III overlapping 100000-110000
## which <- GRange("chrIII", IRanges(100000, 110000))
## param <- ScanBamParam(which=which)
## bf <- scanBam("path/to/bamfile", param=param)


###################################################
### chunk number 10: bar eval=FALSE
###################################################
## #line 303 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
## library(ShortRead)
## dir <- "/not/public"
## bar <- read454(dir)              # Input
## code <- narrow(sread(bar), 1, 8) # Extract bar code
## aBar <- bar[code == "AAGCGCTT"]  # Subset one bar code
## noBar <-                         # Remove bar code
##     narrow(aBar, 11, width(aBar)) 
## pcrPrimer <- "GGACTACCVGGGTATCTAAT"
## trimmed <-                       # Remove primer
##     trimLRPatterns(pcrPrimer, noBar, Lfixed=FALSE)
## writeFastq(trimmed,              # Output
##            file.path(dir, "trimmed.fastq"))


###################################################
### chunk number 11: DGE eval=FALSE
###################################################
## #line 321 "H:/SeattleIntro2010/inst/doc/SequenceAnalysis.Rnw"
## library(GenomicFeatures)
## bamFile <- "/path/to/file.bam"
## aligns <- readGappedAlignments(bamFile)
## ## ... txdb: transcripts from UCSC 'knownGenes'
## exonRanges <- exonsBy(txdb, "tx") 
## ## ... housekeeping
## counts <- countOverlaps(exonRanges, aligns)
## ## ... normalization --> 'highScores' variable
## txs <- transcripts(txdb, 
##            vals=list(tx_id=names(highScores)), 
##            columns=c("tx_id","gene_id"))
## systematicNames <- elementMetadata(txs)[["gene_id"]]


