###################################################
### chunk number 1: setup
###################################################
#line 17 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
options(width = 40)


###################################################
### chunk number 2: design matrix eval=FALSE
###################################################
## #line 187 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
## library(limma)
## design <- model.matrix( ~mol.biol, ALLfilt_bcrneg)
## 


###################################################
### chunk number 3: linear models and ebayes eval=FALSE
###################################################
## #line 197 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
## fit1 <- lmFit(exprs(ALLfilt_bcrneg), design)
## fit2 <- eBayes(fit1)
## topTable(fit2, coef=2, adjust.method="BH", 
##          number=5)


###################################################
### chunk number 4: design matrix eval=FALSE
###################################################
## #line 237 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
## library(limma)
## design <- model.matrix( ~0+mol.biol, ALLfilt_bcrneg)
## colnames(design) <- c("BCR_ABL", "NEG")
## contr <- makeContrasts(BCR_ABL-NEG, levels=designs)
## # contr <- c(1, -1)


###################################################
### chunk number 5: linear models and ebayes eval=FALSE
###################################################
## #line 249 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
## fit <- lmFit(exprs(ALLfilt_bcrneg), design)
## fit1 <- contrasts.fit(fit, contr)
## fit2 <- eBayes(fit1)
## topTable(fit2,  adjust.method="BH",  number=5)


###################################################
### chunk number 6: get the dataset
###################################################
#line 272 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
library(ALL) ## data package
library(hgu95av2.db) ## annotation package
data(ALL)
## subsetting
bcell <- grep("^B", as.character(ALL$BT))
types <- c("NEG", "BCR/ABL")
moltyp <- which(as.character(ALL$mol.biol) %in% types)
ALL_bcrneg <- ALL[, intersect(bcell, moltyp)]

ALL_bcrneg$mol.biol <- factor(ALL_bcrneg$mol.biol)

## nonspecific filtering
library(genefilter)
filt_bcrneg <- nsFilter(ALL_bcrneg, require.entrez=TRUE,
                        remove.dupEntrez=TRUE,
                        var.func=IQR,
                        var.cutoff=0.5, feature.exclude="^AFFX")
## get the real dataset
ALLfilt_bcrneg <- filt_bcrneg$eset


###################################################
### chunk number 7: ttest
###################################################
#line 293 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
tt <- rowttests(ALLfilt_bcrneg, "mol.biol")


###################################################
### chunk number 8: limma
###################################################
#line 296 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
library(limma)
design <- model.matrix( ~mol.biol, ALLfilt_bcrneg)
fit1 <- lmFit(exprs(ALLfilt_bcrneg), design)
fit2 <- eBayes(fit1)


###################################################
### chunk number 9: plotComparison1
###################################################
#line 304 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
library(lattice)
print(xyplot(-fit2$t[,2] ~ tt$statistic, 
       main="79 samples",
       xlab="t-statistics from two-sample t-test", 
       ylab="t-statistics  from moderated t-test (limma)",
       panel=function(...) { 
         panel.xyplot(...); panel.grid(); 
         panel.lmline(..., col="red"); panel.abline(a=0,b=1, col="blue") }))
#plot(-log10(tt$p.value), -log10(fit2$p.value[, 2]),
#     xlab= "-log(10)(p) from two-sample t-test",
#     ylab="-log(10)(p) from moderated t-test (limma)",
#     pch=20, col="blue", main="79 samples")
#abline(c(0,1), col="red")


###################################################
### chunk number 10: subs
###################################################
#line 326 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
subs = c(35, 65, 75, 1, 69, 71)
ALLsubs <- ALLfilt_bcrneg[, subs]
tt2 <- rowttests(ALLsubs, "mol.biol")
fit3 <- eBayes(lmFit(exprs(ALLsubs), design=design[subs,]))


###################################################
### chunk number 11: plotComparison2
###################################################
#line 334 "H:/SeattleIntro2010/inst/doc/MicroarrayAnalysis.Rnw"
print(xyplot(-fit3$t[,2] ~ tt2$statistic, 
       main="6 samples -- 3 for each group",
       xlab="t-statisitcs from two-sample t-test", 
       ylab="t from moderated t-test (limma)",
       panel=function(...) { 
         panel.xyplot(...); panel.grid(); 
         panel.lmline(..., col="red"); panel.abline(a=0,b=1, col="blue") }))
##plot(-log10(tt2$p.value), -log10(fit3$p.value[, 2]),
##     xlab= "-log(10)(p) from two-sample t-test",
 #    ylab="-log(10)(p) from moderated t-test (limma)",
 #    pch=20, col="blue", main="6 samples -- 3 for each group")
#abline(c(0,1), col="red")


