###################################################
### chunk number 1: setup
###################################################
#line 19 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
options(width = 64)


###################################################
### chunk number 2: organnotation
###################################################
#line 71 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
library(org.Hs.eg.db)
org.Hs.eg()
org.Hs.eg_dbInfo()
org.Hs.egGENENAME
org.Hs.eg_dbschema()


###################################################
### chunk number 3: platannotation
###################################################
#line 92 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
library(hgu95av2.db)
hgu95av2()
hgu95av2_dbInfo()
hgu95av2GENENAME
hgu95av2_dbschema()


###################################################
### chunk number 4: basic bimap1
###################################################
#line 137 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
head(toTable(hgu95av2SYMBOL))
get("38187_at",hgu95av2SYMBOL)
mget(c("38912_at","38187_at"),hgu95av2SYMBOL,ifnotfound=NA)


###################################################
### chunk number 5: basic bimap2
###################################################
#line 154 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
##revmap
mget(c("NAT1","NAT2"),revmap(hgu95av2SYMBOL),ifnotfound=NA)
##subsetting
head(toTable(hgu95av2SYMBOL[1:3]))
hgu95av2SYMBOL[["1000_at"]]
revmap(hgu95av2SYMBOL)[["MAPK3"]]
##Or you can combine things
toTable(hgu95av2SYMBOL[c("38912_at","38187_at")])


###################################################
### chunk number 6: merge and cbind
###################################################
#line 176 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
## 1st lets get some data
symbols = head(toTable(hgu95av2SYMBOL),n=3)
chrlocs = head(toTable(hgu95av2CHRLOC),n=3)
pmids = head(toTable(hgu95av2PMID),n=3)
##cbind
cbind(symbols, pmids, chrlocs)
##merge
merge(symbols, pmids, by.x="probe_id", by.y="probe_id") 


###################################################
### chunk number 7: exer1
###################################################
#line 203 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
get("1003_s_at",hgu95av2SYMBOL) 
get("1003_s_at",hgu95av2CHRLOC) 
get("1003_s_at",hgu95av2PATH) 


###################################################
### chunk number 8: keys1 bimap
###################################################
#line 224 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
keys(hgu95av2SYMBOL[1:4])
Lkeys(hgu95av2SYMBOL[1:4])
Rkeys(hgu95av2SYMBOL)[1:4]


###################################################
### chunk number 9: keys2 Bimap
###################################################
#line 243 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
mappedkeys(hgu95av2SYMBOL[1:10])
mappedLkeys(hgu95av2SYMBOL[1:10])
mappedRkeys(hgu95av2SYMBOL[1:10])
count.mappedkeys(hgu95av2SYMBOL[1:100])
count.mappedLkeys(hgu95av2SYMBOL[1:100])
count.mappedRkeys(hgu95av2SYMBOL[1:100])


###################################################
### chunk number 10: Bimap conversion
###################################################
#line 264 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
as.list(hgu95av2SYMBOL[c("38912_at","38187_at")])
unlist(as.list(hgu95av2SYMBOL[c("38912_at","38187_at")]))
unlist2(as.list(hgu95av2SYMBOL[c("38912_at","38187_at")]))

##but what happens when there are 
##repeating values for the left key?
unlist(as.list(revmap(hgu95av2SYMBOL)[c("STAT1","PTGER3")]))   

##unlist2 can help with this
unlist2(as.list(revmap(hgu95av2SYMBOL)[c("STAT1","PTGER3")]))   


###################################################
### chunk number 11: exer2
###################################################
#line 297 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
badRank <- lapply(as.list(revmap(hgu95av2SYMBOL)), length)
tail(sort(unlist(badRank)))


###################################################
### chunk number 12: toggleProbes
###################################################
#line 313 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
## How many probes?
dim(hgu95av2ENTREZID)
## Make a mapping with multiple probes exposed 
multi <- toggleProbes(hgu95av2ENTREZID, "all")
## How many probes?
dim(multi)

## Make a mapping with ONLY multiple probes exposed 
multiOnly <- toggleProbes(multi, "multiple")
## How many probes?
dim(multiOnly)

## Then make a mapping with ONLY single mapping probes
singleOnly <- toggleProbes(multiOnly, "single")
## How many probes?
dim(singleOnly)  


###################################################
### chunk number 13: exer3
###################################################
#line 350 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
mult <- toggleProbes(hgu95av2ENTREZID, "multi")
dim(mult)
multRank <- lapply(as.list(mult), length)
tail(sort(unlist(multRank)))


###################################################
### chunk number 14: entrez to GO
###################################################
#line 389 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
go <- org.Hs.egGO[["1000"]]
length(go)
go[[2]]$GOID
go[[2]]$Ontology


###################################################
### chunk number 15: exer4
###################################################
#line 414 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
##get GOIDs from Hs package.
getGOIDs <- function(ids){
    require(org.Hs.eg.db)
    GOs = mget(ids, org.Hs.egGO, ifnotfound=NA)
    unlist2(lapply(GOs,names))
}
##usage example:
getGOIDs(c("1","10"))


###################################################
### chunk number 16: working with GO
###################################################
#line 441 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
library(GO.db)
ls("package:GO.db")
## find children
as.list(GOMFCHILDREN["GO:0008094"])
## all the descendants (children, grandchildren, and so on)
as.list(GOMFOFFSPRING["GO:0008094"])


###################################################
### chunk number 17: GOTERMS
###################################################
#line 467 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
##Mapping a GOTerms object
go <- GOTERM[1]
GOID(go)
Term(go)

##OR you can supply GO IDs
id = c("GO:0007155","GO:0007156")
GOID(id)
Term(id)
Ontology(id)
Definition(id)


###################################################
### chunk number 18: exer5
###################################################
#line 498 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
##get GOIDs from Hs package.
getGODefs <- function(ids){
    GOids <- getGOIDs(ids)
    defs <- Definition(GOids)
    names(defs) <- names(GOids)
    defs
}
##usage example:
getGODefs(c("1","10"))


###################################################
### chunk number 19: biomaRt1
###################################################
#line 524 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
library(biomaRt)
##list the marts
head(listMarts())
## list the Datasets for a mart
head(listDatasets(useMart("ensembl")))
## now set up the fully qualified mart object
ensembl <- useMart("ensembl", dataset = "hsapiens_gene_ensembl")


###################################################
### chunk number 20: biomaRt2
###################################################
#line 547 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
## need to be able to list filters
head(listFilters(ensembl))
myFilter <- "chromosome_name"
## and list values that you expect back
head(filterOptions(myFilter, ensembl))
myValues <- c("21", "22")
## and list attributes
head(listAttributes(ensembl))
myAttributes <- c("ensembl_gene_id","chromosome_name")


###################################################
### chunk number 21: getBM eval=FALSE
###################################################
## #line 574 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
## ## then you can assemble a query
## res <- getBM(attributes =  myAttributes, 
##              filters =  myFilter,
##              values =  myValues,
##              mart = ensembl)
## head(res)


###################################################
### chunk number 22: exer6
###################################################
#line 601 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
res <- getBM(attributes =  c("entrezgene","hgnc_symbol"), 
             filters =  "entrezgene",
             values =  c("1","10","100"),
             mart = ensembl)
head(res)


###################################################
### chunk number 23: exer7question
###################################################
#line 622 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
load(system.file("data", "result.rda",
                 package = "SeattleIntro2010"))


###################################################
### chunk number 24: exer7
###################################################
#line 635 "H:/SeattleIntro2010/inst/doc/Annotation.Rnw"
ids <- result[,1]
library(hgu95av2.db)
merge(result, toTable(hgu95av2SYMBOL[ids]), by.x="ID", by.y="probe_id")


