## AnnotationDbi
library(org.Sc.sgd.db)
ls(2)

ids <- c("YAL048C", "YDL006W", "YDL029W", "YDL239C", "YGR132C",
         "YGR231C")
toTable(org.Sc.sgdGENENAME[ids])
egids <- toTable(org.Sc.sgdENTREZID[ids])
toTable(org.Sc.sgdGO["YAL048C"])

library(GO.db)
GOTERM[["GO:0000001"]]

## biomaRt
library(biomaRt)

marts <- listMarts()
dim(marts)
head(marts)
mart <- useMart("ensembl")

datasets <- listDatasets(mart)
dim(datasets)
head(datasets)

grep("Saccharomyces", datasets$description)
datasets[20:22,]

ds <- useDataset("scerevisiae_gene_ensembl", mart)

dim(listAttributes(ds))
head(listAttributes(ds), 10)

attrs <- c("ensembl_gene_id", "chromosome_name", "start_position", "strand")

listFilters(ds)[34:36,]
filts <- "entrezgene"
vals <- egids$gene_id

bm <- getBM(attrs, filts, vals, ds)
bm

egids
merge(bm, egids,
      by.x="ensembl_gene_id",
      by.y="systematic_name")

## DNAStringSet
## 
## barcode
## 

dirPath <- "~/sharedrsrc/presentations/presentations/UW-ShortRead-2009/extdata/barcode"
require(RColorBrewer)
dnaPal <- brewer.pal(4,"Set1")
plotAbc <- function(srq, pch="|", cex=2, col=dnaPal, ...) {
    abc <- alphabetByCycle(sread(srq))[1:4,]
    df <- data.frame(Base=rownames(abc)[row(abc)],
                     Cycle=(1:ncol(abc))[col(abc)],
                     Count=as.vector(abc))
    xyplot(log10(Count)~Cycle, group=Base, df, pch=pch, cex=cex,
           col=col, ...)
}

library(ShortRead)

rp <- RochePath(dirPath)
bar <- read454(rp, "1.*fna", "1.*qual")
sread(bar)
quality(bar)

codes <- narrow(sread(bar), 1, 8)
(counts <- tables(codes)[["top"]])

aBar <- bar[as.character(codes)==names(counts)[[1]]]
noBar <- narrow(aBar, 11, width(aBar))

pcrPrimer <- "GGACTACCVGGGTATCTAAT"
trimmed <- trimLRPatterns(pcrPrimer,
                          subject=noBar,
                          Lfixed=FALSE)

t261 <- trimmed[width(trimmed) == 261]

plotAbc(t261, cex=2,
        xlab=list(label="Cycle", cex=2),
        ylab=list(label="log10 Count", cex=2))

## GRanges 
library(GenomicFeatures)
library(IWB2011)
txdbFile <- system.file("extdata", "sacCer2_sgdGene.sqlite",
                        package="IWB2011")
txdb <- loadFeatures(txdbFile)
transcriptsBy(txdb, "gene")
