###################################################
### chunk number 1: setup
###################################################
#line 18 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
options(width=60)
olocale = Sys.setlocale(locale="C")
vers <- R.Version()
vers <- paste(vers$major, vers$minor, sep = ".")


###################################################
### chunk number 2: readData
###################################################
#line 71 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
library(IWB2011)
phenoPath <- system.file( "extdata", "pData.csv", package="IWB2011") 
pdOrig <- read.table(phenoPath)
names(pdOrig)
head(pdOrig)
summary(pdOrig)
table(pdOrig$sex)


###################################################
### chunk number 3: subsetPhenoData
###################################################
#line 120 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
types <- c("NEG", "BCR/ABL")
moltyp <- which(as.character(pdOrig$mol.biol) %in% types)
bcell <- grep("^B", as.character(pdOrig$BT))
indx <- intersect(bcell, moltyp)
psubData <- pdOrig[indx,]


###################################################
### chunk number 4: recodeFactors
###################################################
#line 150 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
levels(psubData$BT)
psubData$BT <-  factor(psubData$BT) 
levels(psubData$BT)
psubData$mol.biol <- factor(psubData$mol.biol)
levels(psubData$mol.biol)


###################################################
### chunk number 5: contingencytables
###################################################
#line 235 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
aggregate(psubData[, "age", drop = FALSE], 
          by= list(sex= psubData$sex, molBiol= psubData[["mol.biol"]]),  
          FUN = mean, na.rm = TRUE )
aggregate(age ~ sex + mol.biol, data = psubData, FUN = mean)
xtabs(relapse ~ sex + mol.biol, data = psubData)


###################################################
### chunk number 6: xyplotFormula eval=FALSE
###################################################
## #line 251 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
## xyplot(y ~ x | c, data, groups = g)


###################################################
### chunk number 7: bwplot
###################################################
#line 288 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
library(lattice)
plt <- bwplot(age ~ sex | mol.biol, psubData)
print(plt)


###################################################
### chunk number 8: sessionInfo
###################################################
#line 304 "e:/packagebuilder/jobs/IWB2011_20110204121253/IWB2011/inst/doc/R-Introduction-Lab.Rnw"
toLatex(sessionInfo())


