###################################################
### chunk number 1: setup
###################################################
#line 18 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
options(width = 72)
library("ALL")
library("genefilter")
library("hgu95av2.db")


###################################################
### chunk number 2: biobase-eset-intro eval=FALSE
###################################################
## #line 71 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
## browseVignettes("Biobase")


###################################################
### chunk number 3: load ALL
###################################################
#line 89 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
library(ALL) # attach the ALL package to the search path
data(ALL)    # load the ALL data into the global work space
ALL          # view the ALL instance -- our first ExpressionSet!


###################################################
### chunk number 4: BT
###################################################
#line 111 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
ALL$BT


###################################################
### chunk number 5: mol.biol
###################################################
#line 131 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
table(ALL$mol.biol == "NEG")


###################################################
### chunk number 6: eset-subset
###################################################
#line 137 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
idx <- ALL$mol.biol == "NEG"
ALL[,idx]


###################################################
### chunk number 7: eset-help eval=FALSE
###################################################
## #line 148 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
## class?ExpressionSet


###################################################
### chunk number 8: get BT
###################################################
#line 179 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
bcell <- grep("^B", as.character(ALL$BT))
types <- c("NEG", "BCR/ABL")
moltyp <- which(as.character(ALL$mol.biol) %in% types)
idx <- intersect(bcell, moltyp)
ALL_bcrneg <- ALL[, idx]
ALL_bcrneg


###################################################
### chunk number 9: factor
###################################################
#line 192 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
ALL_bcrneg$mol.biol <- factor(ALL_bcrneg$mol.biol)


###################################################
### chunk number 10: filter
###################################################
#line 205 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
library(genefilter)
library(hgu95av2.db) ## annotation package for the ALL dataset
filt_bcrneg <- nsFilter(ALL_bcrneg, require.entrez=TRUE,
                        remove.dupEntrez=TRUE, feature.exclude="^AFFX")
filt_bcrneg$filter.log


###################################################
### chunk number 11: get the eset
###################################################
#line 226 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
ALLfilt_bcrneg <- filt_bcrneg$eset


###################################################
### chunk number 12: sessionInfo
###################################################
#line 240 "E:/SinglePackageBuilder/job_42_merlot2/IWB2011/inst/doc/Introduction-Lab.Rnw"
toLatex(sessionInfo())


