###################################################
### chunk number 1: setup
###################################################
#line 17 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
options(width = 40)


###################################################
### chunk number 2: makeUCSC eval=FALSE
###################################################
## #line 139 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
## library(GenomicFeatures)
## mm9KG <-
##   makeTranscriptDbFromUCSC(genome = "mm9",
##                            tablename = "knownGene")


###################################################
### chunk number 3: preload
###################################################
#line 146 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
library(GenomicFeatures)
if(!exists("mm9KG",mode="TranscriptDb")) {
    mm9KG <-
      loadFeatures(system.file("extdata","mm9KG.sqlite",
                                package = "AdvancedR2011"))
}


###################################################
### chunk number 4: saveAndLoad eval=FALSE
###################################################
## #line 155 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
## saveFeatures(mm9KG, file="mm9KG.sqlite")
## mm9KG <-
##   loadFeatures(system.file("extdata", "mm9KG.sqlite",
##                            package = "AdvancedR2011"))


###################################################
### chunk number 5: transcripts
###################################################
#line 167 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
head(transcripts(mm9KG), 3)


###################################################
### chunk number 6: transcriptsDetails eval=FALSE
###################################################
## #line 175 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
## options(verbose=TRUE)
## txs <- transcripts(mm9KG)


###################################################
### chunk number 7: driverUsageAndListTables
###################################################
#line 292 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
library(RSQLite) #loads DBI too, (but we need both)
drv <- SQLite()
con <- dbConnect(drv, dbname=system.file("extdata", 
                 "mm9KG.sqlite", package="AdvancedR2011"))
dbListTables(con)
dbListFields(con,"transcript")


###################################################
### chunk number 8: dbGetQuery
###################################################
#line 305 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
dbGetQuery(con, "SELECT * FROM transcript LIMIT 3")


###################################################
### chunk number 9: dbSendQuery
###################################################
#line 314 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
res <- dbSendQuery(con, "SELECT * FROM transcript")
fetch(res, n= 3)
dbClearResult(res)


###################################################
### chunk number 10: dbDisconnect
###################################################
#line 338 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
   dbDisconnect(con)


###################################################
### chunk number 11: makeNewDb
###################################################
#line 344 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
drv <- SQLite()
con <- dbConnect(drv, dbname="myNewDb.sqlite")


###################################################
### chunk number 12: CreateNewTable
###################################################
#line 349 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
dbGetQuery(con, "CREATE Table foo (id INTEGER, string TEXT)")


###################################################
### chunk number 13: LabelledPreparedQueries
###################################################
#line 390 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
data <- data.frame(c(226089,66745),
                  c("C030046E11Rik","Trpd52l3"), 
                  stringsAsFactors=FALSE)
names(data) <- c("id","string")
sql <- "INSERT INTO foo VALUES ($id, $string)"
dbBeginTransaction(con)
dbGetPreparedQuery(con, sql, bind.data = data)
dbCommit(con)


###################################################
### chunk number 14: ATTACH
###################################################
#line 434 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
db <- system.file("extdata", "mm9KG.sqlite", 
                  package="AdvancedR2011")
dbGetQuery(con, sprintf("ATTACH '%s' AS db",db))


###################################################
### chunk number 15: ATTACHJoin
###################################################
#line 451 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
  sql <- "SELECT * FROM db.gene AS dbg, 
          foo AS f WHERE dbg.gene_id=f.id"
  res <- dbGetQuery(con, sql)
  res


###################################################
### chunk number 16: XML
###################################################
#line 520 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
  ## 1st assemble a URL to use NCBIs web services
  entrezGenes = c(1,100008564)
  library(XML)
  baseUrl <- "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?"
  xsep <- paste(entrezGenes, collapse=",")
  url <- paste(baseUrl,"db=gene&id=",xsep,"&retmode=xml", sep="")
  url

  ## Then parse this XML for use by xpathApply
  EGSet <- xmlParse(url)
  ## Then you can use xpathApply() to parse using xpath expressions
  ## xmlValue() returns the contents of that tag
  speciesNames <- unlist(xpathApply(EGSet, "//Org-ref_taxname", xmlValue))
  speciesNames


###################################################
### chunk number 17: cleanup
###################################################
#line 541 "e:/packagebuilder/jobs/AdvancedR2011_20110214135039/AdvancedR2011/inst/doc/UsingSQLiteInR.Rnw"
 file.remove("myNewDb.sqlite")


