
###################################################
### chunk number 1: finding FCSfiles
###################################################
library(flowCore)
library(flowTrack)
library(flowViz)
library(flowStats)

system.file("extdata", package = "flowTrack")


###################################################
### chunk number 2: Read FlowSet
###################################################
pth <- system.file("extdata", package = "flowTrack")
flowData <- read.flowSet(path = pth, phenoData="annotation.txt", 
                transformation=FALSE)


###################################################
### chunk number 3: Update sampleNames
###################################################
head(pData(flowData))
sampleNames(flowData) <- pData(flowData)[,"PatientID"]


###################################################
### chunk number 4: Update Description Fields
###################################################
for(i in seq_len(length(flowData))){
    pData(parameters(flowData[[i]]))[,"desc"] <- c(NA, NA, "CD8", "CD69",
                                                   "CD4","CD3", "HLADr","NA")
}



###################################################
### chunk number 5: scatter plot matrix
###################################################
splom(flowData[[1]])



###################################################
### chunk number 6: transform Data
###################################################
tf <-  transformList(colnames(flowData)[3:7], asinh)
tData <- transform(flowData, tf)


###################################################
### chunk number 7: xyplot FITC PEA
###################################################
xyplot( `FITC-A` ~ `PE-A`, tData, 
                    main=" My xyplot of FITC-A/PE-A")



###################################################
### chunk number 8: densityplot FITC
###################################################
densityplot( ~ `FITC-A`, tData,
                    main=" My density plot of FITC-A")


###################################################
### chunk number 9: basicworkFlow
###################################################
mw <- workFlow(tData, name ="myWork")
rg <- rectangleGate("FSC-A"=c(100, 600), "SSC-A"=c(100, 600),
        filterId="rectangle")
add(mw, rg, parent="base view")
mw


###################################################
### chunk number 10: rectGatePlot
###################################################
xyplot(`FSC-A` ~ `SSC-A`, Data( mw[["rectangle+"]]))


###################################################
### chunk number 11: start the work flow
###################################################
colnames(flowData) <- c("FSC", "SSC","CD8","CD69", "CD4","CD3",
                        "HLADr", "Time")
wf <- workFlow(flowData, name="biocExample")


###################################################
### chunk number 12: Transform the data
###################################################
tf <- transformList(colnames(Data(wf[["base view"]]))[3:7], asinh,
                    transformationId="asinh")
add(wf, tf)
wf


###################################################
### chunk number 13: Boundary filter FSC SSC channels
###################################################
boundFilt <- boundaryFilter(filterId="boundFilt", x=c("FSC","SSC"))
add(wf,boundFilt,parent="asinh")



###################################################
### chunk number 14: lymphGate
###################################################
lg <- lymphGate(Data(wf[["boundFilt+"]]), channels=c("FSC", "SSC"),
                preselection="CD3", filterId="TCells", eval=FALSE,
                scale=2.5)
add(wf, lg$n2gate, parent="boundFilt+")

xyplot(SSC ~ FSC| PatientID, wf[["TCells+"]],
         par.settings=list(gate=list(col="red",
         fill="red", alpha=0.3)))



###################################################
### chunk number 15: DataBeforeNormalization
###################################################
densityplot(PatientID~., Data(wf[["TCells+"]]), 
            channels=c("CD3","CD4","CD8"), groups=GroupID,
            scales=list(y=list(draw=F)),
            filter=lapply(c("CD3","CD4","CD8"), curv1Filter),
            layout=c(3,1))



###################################################
### chunk number 16: Data after normalization
###################################################
pars <- colnames(Data(wf[["base view"]]))[c(3,4,5,6)]
norm <- normalization(normFun=function(x, parameters, ...)
                      warpSet(x, parameters,...),
                      parameters=pars,
                      normalizationId="Warping")
add(wf, norm, parent="TCells+")


###################################################
### chunk number 17: createNormalizedPlot
###################################################
densityplot(PatientID~., Data(wf[["Warping"]]),
                  channels=c("CD3","CD4","CD8"), groups=GroupID,
                  scales=list(y=list(draw=F)),
                  filter=lapply(c("CD3","CD4","CD8"), curv1Filter),
                  layout=c(3,1))


###################################################
### chunk number 18: QuadrantgateCD3+CD4+
###################################################
qgate <- quadrantGate(Data(wf[["Warping"]]), stains=c("CD3", "CD4"),
                      plot=FALSE, filterId="CD3CD4")
add(wf, qgate, parent="Warping")


###################################################
### chunk number 19: PlotQuadrantGateCD3+CD4+
###################################################
xyplot(CD3 ~ CD4 | PatientID, wf[["CD3+CD4+"]] )



###################################################
### chunk number 20: QuadrantGateCD3+CD8+
###################################################
qgate <- quadrantGate(Data(wf[["Warping"]]), stains=c("CD3", "CD8"),
                      plot=FALSE, filterId="CD3CD8")
add(wf, qgate, parent="Warping")


###################################################
### chunk number 21: PlotQuadrantGateCD3+CD8+
###################################################
xyplot(CD3 ~ CD8 | PatientID, wf[["CD3+CD8+"]])



###################################################
### chunk number 22: HLADrActivatedCD3+CD4+
###################################################
HLADr1 <- rangeGate(Data(wf[["CD3+CD4+"]]), stain="HLADr", plot=FALSE,
                    alpha=0.75, filterId="CD3+CD4+HLAct")
add(wf, HLADr1, parent="CD3+CD4+")


###################################################
### chunk number 23: PlotHLADrActivatedCD3+CD4+
###################################################
densityplot(PatientID ~ HLADr, Data(wf[["CD3+CD4+"]]),
            refline=HLADr1@min)


###################################################
### chunk number 24: HLADrActivatedCD3+CD8+
###################################################
HLADr2 <- rangeGate(Data(wf[["CD3+CD8+"]]), stain="HLADr", plot=FALSE,
                    alpha=0.75, filterId="CD3+CD8+HLAct")
add(wf, HLADr2, parent="CD3+CD8+")


###################################################
### chunk number 25: PlotHLADrActivatedCD3+CD8+
###################################################
densityplot(PatientID ~ HLADr, Data(wf[["CD3+CD8+"]]), 
            refline=HLADr2@min)


###################################################
### chunk number 26: SummaryHLADrActivatedCD3+CD4+
###################################################
pr <-fsApply(Data(wf[["CD3+CD4+HLAct-"]]),nrow)*100 /
        fsApply(Data(wf[["boundFilt+"]]),nrow)
res <- data.frame(pr, pData(Data(wf[["CD3+CD4+"]]))[c("GroupID","PatientID")])


###################################################
### chunk number 27: SummaryHLADrActivatedCD3+CD4+
###################################################
barchart(reorder(PatientID, as.numeric(factor(GroupID))) ~ pr, 
            data=res, groups=GroupID,stack=TRUE, 
            auto.key=list(points = FALSE, rectangles = TRUE, space = "right"),
            main="Activated CD3+CD4+ T cells", 
            xlab="Percentage of activated cells")


###################################################
### chunk number 28: SummaryHLADRrActivatedCD3+CD8+
###################################################
pr <- fsApply(Data(wf[["CD3+CD8+HLAct-"]]),nrow)*100 /
          fsApply(Data(wf[["boundFilt+"]]),nrow)
res <- data.frame(pr,pData(Data(wf[["CD3+CD8+"]]))[c("GroupID","PatientID")])


###################################################
### chunk number 29: PlotSummaryHLADRrActivatedCD3+CD8+
###################################################
barchart(reorder(PatientID,as.numeric(factor(GroupID))) ~ pr,
            data=res, groups=GroupID, stack=TRUE,
            auto.key = list(points = FALSE, rectangles = TRUE, space = "right"),
            main="Activated  CD3+CD8+ T cells",
            xlab=" Percentage of activated cells")



