library(Rmpi)
mpi.spawn.Rslaves()

## load gwas on each node
mpi.remote.exec({
    fname0 <- "/home/mtmorgan/hpc/extdata/gwas_2.csv"
    gwas <<- read.csv(fname0, row.names=1)
}, ret=FALSE)

## evaluate in parallel
snp0 <- function(i) {
    snps <- gwas[,-(1:3)] ## global reference 'gwas'
    glm(CaseControl ~ Age + Sex + snps[,i], family=binomial, 
        data=gwas)$coef
}
system.time(result <- mpi.parLapply(1:200, snp0))

result[[1]]

mpi.close.Rslaves()
mpi.quit()
