###################################################
### chunk number 1: setup
###################################################
options(width = 40)


###################################################
### chunk number 2: io-sketch eval=FALSE
###################################################
## colClasses <-
##   c("NULL", "integer", "numeric", "NULL")
## df <- read.table("myfile", colClasses=colClasses)


###################################################
### chunk number 3: preallocate-and-fill-sketch eval=FALSE
###################################################
## result <- numeric(nrow(df))
## for (i in seq_len(nrow(df)))
##   result[[i]] <- some_calc(df[i,])


###################################################
### chunk number 4: iterative
###################################################
x <- runif(100000); x2 <- x^2
m <- matrix(x2, nrow=1000); y <- rowSums(m)


###################################################
### chunk number 5: inappropriate-functions-2 eval=FALSE
###################################################
## library(limma) # microarray linear models
## fit <- lmFit(eSet, design)


###################################################
### chunk number 6: algo-poly
###################################################
x <- 1:100; s <- sample(x, 10)
inS <- x %in% s


###################################################
### chunk number 7: system.time
###################################################
m <- matrix(runif(200000), 20000)
replicate(5, system.time(apply(m, 1, sum))[[1]])
replicate(5, system.time(rowSums(m))[[1]])


###################################################
### chunk number 8: identical
###################################################
res1 <- apply(m, 1, sum)
res2 <- rowSums(m)
identical(res1, res2)
identical(c(1, -1), c(x=1, y=-1))
all.equal(c(1, -1), c(x=1, y=-1), check.attributes=FALSE)


###################################################
### chunk number 9: Rprof eval=FALSE
###################################################
## tmpf = tempfile()
## Rprof(tmpf)
## res1 <- apply(m,  1, sum)
## Rprof(NULL); summaryRprof(tmpf)


###################################################
### chunk number 10: gwas-input
###################################################
fname1 <- system.file("extdata", "gwas_2.rda", 
                      package="EfficientR")
load(fname1)
gwas[1:2, 1:8]


###################################################
### chunk number 11: glm-1
###################################################
snp0 <- function(i, gwas) {
    snp <- gwas[[i+3L]]
    glm(CaseControl ~ Age + Sex + snp,
        family=binomial, data=gwas)$coef
}
system.time(sapply(1:10, snp0, gwas))


###################################################
### chunk number 12: text-io
###################################################
ftmp <- tempfile()
write.csv(gwas, ftmp)
system.time(read.csv(ftmp, row.names=1))[[3]]
save(gwas, file=ftmp)
replicate(5, system.time(load(ftmp, new.env()))[[3]])
save(gwas, file=ftmp, compress=FALSE)
replicate(5, system.time(load(ftmp, new.env()))[[3]])
unlink(ftmp)


###################################################
### chunk number 13: sql-setup
###################################################
db0 <- tempfile()
library(RSQLite)
drv <- dbDriver("SQLite")
conn <- dbConnect(drv, dbname=db0)


###################################################
### chunk number 14: sql-create
###################################################
gwasPhenotypes <- gwas[,1:3]
dbWriteTable(conn, "gwasPhenotypes", gwasPhenotypes)


###################################################
### chunk number 15: db-fetch
###################################################
q <- dbSendQuery(conn, "SELECT * FROM gwasPhenotypes")
fetch(q, n = 2) # first 2; n = -1 for all
invisible(dbClearResult(q)) # close out query


###################################################
### chunk number 16: db-clean
###################################################
invisible(dbDisconnect(conn))


###################################################
### chunk number 17: ncdf-setup
###################################################
ngwas <- local({
    x0 <- lapply(gwas[,-(1:3)], as.integer)
    matrix(unlist(x0, use.names=FALSE), ncol=length(x0))
})
ncdf0 <- tempfile()
library(ncdf)


###################################################
### chunk number 18: ncdf-define-dims
###################################################
sampd <- dim.def.ncdf("Sample", "id", seq_len(nrow(ngwas)))
snpd <- dim.def.ncdf("SNP", "id", seq_len(ncol(ngwas)))
snpv <- var.def.ncdf("Genotype", 
                     units="1: AA, 2: AB; 3: BB",
                     dim=list(sampd, snpd), 
                     missval=-1L, prec="integer")


###################################################
### chunk number 19: ncdf-create-file
###################################################
nc <- create.ncdf(ncdf0, snpv)
put.var.ncdf(nc, snpv, ngwas)
invisible(close(nc))


###################################################
### chunk number 20: ncdf-read
###################################################
nc <- open.ncdf(ncdf0)
system.time({
    nc_gwas <- get.var.ncdf(nc, "Genotype")
})[[1]]


###################################################
### chunk number 21: ncdf-read-II
###################################################
g <- get.var.ncdf(nc, "Genotype", start=c(30, 100),
       count=c(10, 20)) # samples 30:40, snps 100:120
g <- get.var.ncdf(nc, "Genotype", start=c(1,1000),
       count=c(-1, 100)) # all samples, snps 1000:1100
invisible(close(nc))


###################################################
### chunk number 22: foreach
###################################################
library(foreach)
if ("windows" != .Platform$OS.type) {
    library(doMC); registerDoMC()
    res <- foreach(i=1:10) %dopar% snp0(i, gwas)
}


###################################################
### chunk number 23: iterators
###################################################
snp1 <- function(snp, gwas) {
    glm(CaseControl ~ Age + Sex + snp,
        family=binomial, data=gwas)$coef
}
snps <- gwas[,11:20]
res <- foreach(it=iter(snps, "column")) %dopar% 
           snp1(it, gwas)


