/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.writers;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class PhylipWriter
implements SequenceWriter {
    private PrintStream out;
    private int seqLength;
    private static final int TAX_ID_LENGTH = 10;

    public PhylipWriter(OutputStream o, int numTaxa, int seqLength) {
        this.out = new PrintStream(o);
        this.out.println(numTaxa + "  " + seqLength);
        this.seqLength = seqLength;
    }

    private static String getSeqId(String seqid) {
        for (int index = seqid.length(); index < 10; ++index) {
            seqid = seqid + " ";
        }
        return seqid;
    }

    @Override
    public void writeSeq(Sequence seq) throws IOException {
        this.writeSeq(seq.getSeqName(), seq.getSeqString());
    }

    public void writeSeq(String seqid, String seqString) throws IOException {
        if (seqString.length() != this.seqLength) {
            throw new IOException("Sequencec seq " + seqid + " is not the expected length (" + this.seqLength + ")");
        }
        this.out.println(PhylipWriter.getSeqId(seqid) + seqString);
    }

    public void writeSeq(String seqid, String desc, String seqString) throws IOException {
        throw new UnsupportedOperationException("Phylip format doesn't support sequence descriptions");
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public static void writeSequences(List<Sequence> seqs, OutputStream out) throws IOException {
        PhylipWriter writer = new PhylipWriter(out, seqs.size(), seqs.get(0).getSeqString().length());
        for (Sequence seq : seqs) {
            writer.writeSeq(seq);
        }
        out.close();
    }
}

