## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.wide=TRUE)

## ----echo=FALSE, out.width = "20%"--------------------------------------------
knitr::include_graphics("figures/logo_gINTomics.png")
# <img src=./figures/logo_gINTomics.png class="center" />

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("gINTomics")
# 
# #devtools::install_github("angelovelle96/gINTomics")
# 

## ----message=FALSE------------------------------------------------------------
# loading packages
library(gINTomics)
library(MultiAssayExperiment)
library(shiny)
data("mmultiassay_ov")
mmultiassay_ov

## ----message=FALSE------------------------------------------------------------
## Here we just select part of the data o speed up the process
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:400,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)

gene_exp_matrix <- as.matrix(assay(mmultiassay_ov[["gene_exp"]]))
miRNA_exp_matrix <- as.matrix(assay(mmultiassay_ov[["miRNA_exp"]]))
meth_matrix <- as.matrix(assay(mmultiassay_ov[["methylation"]]))
gene_cnv_matrix <- as.matrix(assay(mmultiassay_ov[["cnv_data"]]))
miRNA_cnv_matrix <- as.matrix(assay(mmultiassay_ov[["miRNA_cnv_data"]]))

## ----message=FALSE------------------------------------------------------------
new_multiassay <- create_multiassay(methylation = meth_matrix, 
                                    gene_exp = gene_exp_matrix,
                                    cnv_data = gene_cnv_matrix,
                                    miRNA_exp = miRNA_exp_matrix,
                                    miRNA_cnv_data = miRNA_cnv_matrix)

new_multiassay

## ----message=FALSE------------------------------------------------------------
gene_genomic_integration <- run_genomic_integration(expression = t(gene_exp_matrix),
                                                    cnv_data = t(gene_cnv_matrix),
                                                    methylation = t(meth_matrix))
summary(gene_genomic_integration)

## ----message=FALSE------------------------------------------------------------
gene_cnv_integration <- run_cnv_integration(expression = t(gene_exp_matrix),
                                            cnv_data = t(gene_cnv_matrix))
summary(gene_cnv_integration)

## ----message=FALSE------------------------------------------------------------
gene_met_integration <- run_met_integration(expression = t(gene_exp_matrix),
                                            methylation = t(meth_matrix))
summary(gene_met_integration)

## ----message=FALSE------------------------------------------------------------
tf_target_integration <- run_tf_integration(expression = t(gene_exp_matrix),
                                            type = "tf")
summary(tf_target_integration)

## ----message=FALSE------------------------------------------------------------
miRNA_target_integration <- run_tf_integration(expression = t(gene_exp_matrix),
                                               tf_expression = t(miRNA_exp_matrix),
                                               type = "miRNA_target")
summary(miRNA_target_integration)

## ----message=FALSE------------------------------------------------------------
tf_miRNA_integration <- run_tf_integration(expression = t(miRNA_exp_matrix),
                                               tf_expression = t(gene_exp_matrix),
                                               type = "tf_miRNA")
summary(tf_miRNA_integration)

## ----message=FALSE------------------------------------------------------------
## Here we run the model
multiomics_integration <- run_multiomics(data = new_multiassay)
summary(multiomics_integration)

## ----eval=FALSE---------------------------------------------------------------
# run_shiny(multiomics_integration)

## -----------------------------------------------------------------------------
data_table <- extract_model_res(multiomics_integration)
data_table <- data_table[data_table$cov!="(Intercept)",]
# plot_network(data_table, num_interactions = 200)


## -----------------------------------------------------------------------------
# plot_venn(data_table)


## -----------------------------------------------------------------------------
# plot_volcano(data_table, omics = "gene_genomic_res", cnv_met = "cnv")
# plot_volcano(data_table, omics = "gene_genomic_res", cnv_met = "met")


## -----------------------------------------------------------------------------
# plot_ridge(data_table, omics = "gene_genomic_res", cnv_met = "cnv")
# plot_ridge(data_table, omics = "gene_genomic_res", cnv_met = "met")


## ----eval=FALSE---------------------------------------------------------------
# # plot_chr_distribution(data_table = data_table,
# #                     omics = "gene_genomic_res")
# 

## ----eval=FALSE---------------------------------------------------------------
# # plot_tf_distribution(data_table = data_table)
# 

## -----------------------------------------------------------------------------
#gen_enr <- run_genomic_enrich(multiomics_integration, qvalueCutoff = 1, pvalueCutoff = 0.05, pAdjustMethod = "none")
#dot_plotly(gen_enr$cnv[[1]]$go)


## -----------------------------------------------------------------------------
sessionInfo()

