/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Random;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSample {
    private RandomSample() {
    }

    public static Iterator<Integer> withoutReplacement(final Random random, final int n, final int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if (n < n2) {
            return new Iterator<Integer>(){
                private int i = 0;
                private int M = n2;
                private int r = n2 - n;

                @Override
                public boolean hasNext() {
                    return this.i < n;
                }

                @Override
                public Integer next() {
                    if (this.i >= n) {
                        throw new NoSuchElementException();
                    }
                    ++this.i;
                    double d = random.nextDouble();
                    double d2 = 1.0;
                    while (true) {
                        if ((d2 = d2 * (double)this.r / (double)this.M) <= d) {
                            int n3 = n2 - this.M;
                            --this.M;
                            return n3;
                        }
                        --this.M;
                        --this.r;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Integer>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n2;
            }

            @Override
            public Integer next() {
                if (this.i >= n2) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int withoutReplacement(Random random, int n, int n2, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if (n < n2) {
            int n3 = n2;
            int n4 = n2 - n;
            block0: for (int i = 0; i < n; ++i) {
                double d = random.nextDouble();
                double d2 = 1.0;
                while (true) {
                    if ((d2 = d2 * (double)n4 / (double)n3) <= d) {
                        nArray[i] = n2 - n3;
                        --n3;
                        continue block0;
                    }
                    --n3;
                    --n4;
                }
            }
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        return n2;
    }

    public static Iterator<Long> withoutReplacement(final Random random, final int n, final long l) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if ((long)n < l) {
            return new Iterator<Long>(){
                private int i = 0;
                private long M = l;
                private long r = l - (long)n;

                @Override
                public boolean hasNext() {
                    return this.i < n;
                }

                @Override
                public Long next() {
                    if (this.i >= n) {
                        throw new NoSuchElementException();
                    }
                    ++this.i;
                    double d = random.nextDouble();
                    double d2 = 1.0;
                    while (true) {
                        if ((d2 = d2 * (double)this.r / (double)this.M) <= d) {
                            long l2 = l - this.M;
                            --this.M;
                            return l2;
                        }
                        --this.M;
                        --this.r;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Long>(){
            private long i = 0L;

            @Override
            public boolean hasNext() {
                return this.i < l;
            }

            @Override
            public Long next() {
                if (this.i >= l) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int withoutReplacement(Random random, int n, long l, long[] lArray) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if ((long)n < l) {
            long l2 = l;
            long l3 = l - (long)n;
            block0: for (int i = 0; i < n; ++i) {
                double d = random.nextDouble();
                double d2 = 1.0;
                while (true) {
                    if ((d2 = d2 * (double)l3 / (double)l2) <= d) {
                        lArray[i] = l - l2;
                        --l2;
                        continue block0;
                    }
                    --l2;
                    --l3;
                }
            }
            return n;
        }
        int n2 = 0;
        while ((long)n2 < l) {
            lArray[n2] = n2;
            ++n2;
        }
        return (int)l;
    }
}

