/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class ByteSequence {
    private LinkedList<byte[]> myChunkList = new LinkedList();
    private LinkedList<Integer> myLengthList = new LinkedList();
    private int myTotalLength;

    public ByteSequence(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteSequence(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.myChunkList.add(byArray2);
        this.myLengthList.add(n2);
        this.myTotalLength = n2;
    }

    public ByteSequence(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            byte[] byArray;
            int n;
            while ((n = inputStream.read(byArray = new byte[4096])) != -1) {
                this.myChunkList.add(byArray);
                this.myLengthList.add(n);
                this.myTotalLength += n;
                if (this.myTotalLength >= 0) continue;
                throw new IOException("ByteSequence(): Input stream too long");
            }
            inputStream.close();
        }
    }

    public ByteSequence(ByteSequence byteSequence) {
        byte[] byArray = byteSequence.toByteArray();
        this.myChunkList.add(byArray);
        this.myLengthList.add(byArray.length);
        this.myTotalLength = byArray.length;
    }

    public int length() {
        return this.myTotalLength;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.myTotalLength];
        this.copy(byArray);
        return byArray;
    }

    public int copy(byte[] byArray) {
        return this.copy(byArray, 0, byArray.length);
    }

    public int copy(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        Iterator iterator = this.myChunkList.iterator();
        Iterator iterator2 = this.myLengthList.iterator();
        while (n2 > 0 && iterator.hasNext()) {
            byte[] byArray2 = (byte[])iterator.next();
            int n4 = (Integer)iterator2.next();
            int n5 = Math.min(n4, n2);
            System.arraycopy(byArray2, 0, byArray, n, n5);
            n += n5;
            n2 -= n5;
            n3 += n5;
        }
        return n3;
    }

    public void write(OutputStream outputStream) throws IOException {
        Iterator iterator = this.myChunkList.iterator();
        Iterator iterator2 = this.myLengthList.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            int n = (Integer)iterator2.next();
            outputStream.write(byArray, 0, n);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        Iterator iterator = this.myChunkList.iterator();
        Iterator iterator2 = this.myLengthList.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            int n = (Integer)iterator2.next();
            dataOutput.write(byArray, 0, n);
        }
    }
}

