/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontSelector
extends JPanel {
    private static final int GAP = 5;
    private String[] myFontFamilies;
    private Font mySelectedFont;
    private JComboBox myFontFamilyComboBox;
    private JComboBox myFontStyleComboBox;
    private JSpinner myFontSizeSpinner;
    private JLabel myTextSample;

    public FontSelector() {
        this.setLayout(new BoxLayout(this, 0));
        this.myFontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.myFontFamilyComboBox = new JComboBox<String>(this.myFontFamilies);
        Dimension dimension = this.myFontFamilyComboBox.getPreferredSize();
        this.myFontFamilyComboBox.setMinimumSize(dimension);
        this.myFontFamilyComboBox.setMaximumSize(dimension);
        this.myFontFamilyComboBox.setPreferredSize(dimension);
        this.myFontFamilyComboBox.setEditable(false);
        this.myFontFamilyComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FontSelector.this.updateSelectedFont();
                }
            }
        });
        this.add(this.myFontFamilyComboBox);
        this.add(Box.createHorizontalStrut(5));
        this.myFontStyleComboBox = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic", "Bold Italic"});
        dimension = this.myFontStyleComboBox.getPreferredSize();
        this.myFontStyleComboBox.setMinimumSize(dimension);
        this.myFontStyleComboBox.setMaximumSize(dimension);
        this.myFontStyleComboBox.setPreferredSize(dimension);
        this.myFontStyleComboBox.setEditable(false);
        this.myFontStyleComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FontSelector.this.updateSelectedFont();
                }
            }
        });
        this.add(this.myFontStyleComboBox);
        this.add(Box.createHorizontalStrut(5));
        this.myFontSizeSpinner = new JSpinner(new SpinnerNumberModel(12, 1, 144, 1));
        dimension = this.myFontSizeSpinner.getPreferredSize();
        this.myFontSizeSpinner.setMinimumSize(dimension);
        this.myFontSizeSpinner.setMaximumSize(dimension);
        this.myFontSizeSpinner.setPreferredSize(dimension);
        this.myFontSizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FontSelector.this.updateSelectedFont();
            }
        });
        this.add(this.myFontSizeSpinner);
        this.add(Box.createHorizontalStrut(5));
        this.myTextSample = new JLabel("Quick Brown Fox 123");
        dimension = this.myTextSample.getPreferredSize();
        this.myTextSample.setMinimumSize(dimension);
        this.myTextSample.setMaximumSize(dimension);
        this.myTextSample.setPreferredSize(dimension);
        this.add(this.myTextSample);
        this.setSelectedFont(new Font("SansSerif", 0, 12));
    }

    public Font getSelectedFont() {
        return this.mySelectedFont;
    }

    public void setSelectedFont(Font font) {
        this.myFontFamilyComboBox.setSelectedItem(font.getFamily());
        int n = 0;
        if (font.isBold()) {
            ++n;
        }
        if (font.isItalic()) {
            n += 2;
        }
        this.myFontStyleComboBox.setSelectedIndex(n);
        this.myFontSizeSpinner.setValue(new Integer(font.getSize()));
    }

    private void updateSelectedFont() {
        int n = this.myFontFamilyComboBox.getSelectedIndex();
        int n2 = this.myFontStyleComboBox.getSelectedIndex();
        int n3 = (Integer)this.myFontSizeSpinner.getValue();
        this.mySelectedFont = new Font(this.myFontFamilies[n], n2, n3);
        this.myTextSample.setFont(this.mySelectedFont);
    }
}

