/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.pj.Comm;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.replica.ReplicatedInteger;
import edu.rit.util.LongRange;
import edu.rit.util.Random;

public class Test20 {
    static Comm world;
    static int size;
    static int rank;
    static long seed;
    static long N;
    static ReplicatedInteger littlest;
    static LongRange range;

    private Test20() {
    }

    public static void main(String[] stringArray) throws Exception {
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            Test20.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        littlest = new ReplicatedInteger(IntegerOp.MINIMUM, Integer.MAX_VALUE, 1);
        range = new LongRange(0L, N - 1L).subrange(size, rank);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(range.lb(), range.ub(), new LongForLoop(){
                    Random prng = Random.getInstance(seed);

                    public void run(long l, long l2) throws Exception {
                        this.prng.setSeed(seed);
                        this.prng.skip(l);
                        for (long i = l; i <= l2; ++i) {
                            littlest.reduce(this.prng.nextInt(Integer.MAX_VALUE));
                        }
                    }
                });
            }
        });
        world.barrier();
        Thread.sleep(2000L);
        System.out.println("littlest = " + littlest + " (" + rank + ")");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<np> -Dpj.nt=<nt> edu.rit.pj.test.Test20 <seed> <N>");
        System.err.println("<np> = Number of processes");
        System.err.println("<nt> = Number of CPUs per process");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random integers");
        System.exit(1);
    }
}

