/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.CharacterOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedCharacter
extends Number {
    private CharacterOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedCharacter(CharacterOp characterOp) {
        this(characterOp, '\u0000', 0, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp characterOp, char c) {
        this(characterOp, c, 0, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp characterOp, char c, int n) {
        this(characterOp, c, n, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp characterOp, char c, int n, Comm comm) {
        if (characterOp == null) {
            throw new NullPointerException("ReplicatedCharacter(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedCharacter(): comm is null");
        }
        this.myOp = characterOp;
        this.myValue = new AtomicInteger(c);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public char get() {
        return (char)this.myValue.get();
    }

    public char reduce(char c) throws IOException {
        char c2;
        char c3;
        while (!this.myValue.compareAndSet(c3 = (char)this.myValue.get(), c2 = this.myOp.op(c3, c))) {
        }
        if (c2 != c3) {
            this.myComm.floodSend(this.myTag, CharacterBuf.buffer(c2));
        }
        return c2;
    }

    public String toString() {
        return Character.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            CharacterItemBuf characterItemBuf = CharacterBuf.buffer();
            try {
                while (true) {
                    char c;
                    char c2;
                    ReplicatedCharacter.this.myComm.floodReceive(ReplicatedCharacter.this.myTag, characterItemBuf);
                    do {
                        c2 = (char)ReplicatedCharacter.this.myValue.get();
                        c = ReplicatedCharacter.this.myOp.op(c2, characterItemBuf.item);
                    } while (!ReplicatedCharacter.this.myValue.compareAndSet(c2, c));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

