/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.Message;
import edu.rit.util.ByteSequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;

public abstract class JobBackendMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = 3747140854797048519L;

    public JobBackendMessage() {
    }

    public JobBackendMessage(int n) {
        super(n);
    }

    public static JobBackendMessage cancelJob(JobFrontendRef jobFrontendRef, String string) {
        return new CancelJobMessage(jobFrontendRef, string);
    }

    public static JobBackendMessage commenceJob(JobFrontendRef jobFrontendRef, InetSocketAddress[] inetSocketAddressArray, InetSocketAddress[] inetSocketAddressArray2, InetSocketAddress[] inetSocketAddressArray3, Properties properties, String string, String[] stringArray) {
        return new CommenceJobMessage(jobFrontendRef, inetSocketAddressArray, inetSocketAddressArray2, inetSocketAddressArray3, properties, string, stringArray);
    }

    public static JobBackendMessage jobFinished(JobFrontendRef jobFrontendRef) {
        return new JobFinishedMessage(jobFrontendRef);
    }

    public static JobBackendMessage renewLease(JobFrontendRef jobFrontendRef) {
        return new RenewLeaseMessage(jobFrontendRef);
    }

    public static JobBackendMessage reportResource(JobFrontendRef jobFrontendRef, String string, byte[] byArray) {
        return new ReportResourceMessage(jobFrontendRef, string, byArray);
    }

    public static JobBackendMessage reportResource(JobFrontendRef jobFrontendRef, String string, ByteSequence byteSequence) {
        return new ReportResourceMessage(jobFrontendRef, string, byteSequence);
    }

    public static JobBackendMessage outputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        return new OutputFileOpenResultMessage(jobFrontendRef, n, n2, iOException);
    }

    public static JobBackendMessage outputFileWriteResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        return new OutputFileWriteResultMessage(jobFrontendRef, n, iOException);
    }

    public static JobBackendMessage outputFileFlushResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        return new OutputFileFlushResultMessage(jobFrontendRef, n, iOException);
    }

    public static JobBackendMessage outputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        return new OutputFileCloseResultMessage(jobFrontendRef, n, iOException);
    }

    public static JobBackendMessage inputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        return new InputFileOpenResultMessage(jobFrontendRef, n, n2, iOException);
    }

    public static JobBackendMessage inputFileReadResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        return new InputFileReadResultMessage(jobFrontendRef, n, n2, iOException);
    }

    public static JobBackendMessage inputFileSkipResult(JobFrontendRef jobFrontendRef, int n, long l, IOException iOException) {
        return new InputFileSkipResultMessage(jobFrontendRef, n, l, iOException);
    }

    public static JobBackendMessage inputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        return new InputFileCloseResultMessage(jobFrontendRef, n, iOException);
    }

    public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    private static class InputFileCloseResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -5645040374361899565L;
        private int ffd;
        private IOException exc;

        public InputFileCloseResultMessage() {
        }

        public InputFileCloseResultMessage(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
            super(2);
            this.ffd = n;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.inputFileCloseResult(jobFrontendRef, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class InputFileSkipResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 5050948958179612039L;
        private int ffd;
        private long len;
        private IOException exc;

        public InputFileSkipResultMessage() {
        }

        public InputFileSkipResultMessage(JobFrontendRef jobFrontendRef, int n, long l, IOException iOException) {
            super(2);
            this.ffd = n;
            this.len = l;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.inputFileSkipResult(jobFrontendRef, this.ffd, this.len, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeLong(this.len);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.len = objectInput.readLong();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class InputFileReadResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 4542261695089387333L;
        private int ffd;
        private int len;
        private IOException exc;

        public InputFileReadResultMessage() {
        }

        public InputFileReadResultMessage(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
            super(2);
            this.ffd = n;
            this.len = n2;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.inputFileReadResult(jobFrontendRef, this.ffd, null, this.len, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeInt(this.len);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.len = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class InputFileOpenResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -1082499193559062581L;
        private int bfd;
        private int ffd;
        private IOException exc;

        public InputFileOpenResultMessage() {
        }

        public InputFileOpenResultMessage(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
            super(2);
            this.bfd = n;
            this.ffd = n2;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.inputFileOpenResult(jobFrontendRef, this.bfd, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.bfd);
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.bfd = objectInput.readInt();
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class OutputFileCloseResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 5976163600237430235L;
        private int ffd;
        private IOException exc;

        public OutputFileCloseResultMessage() {
        }

        public OutputFileCloseResultMessage(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
            super(2);
            this.ffd = n;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.outputFileCloseResult(jobFrontendRef, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class OutputFileFlushResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 8921581871627030306L;
        private int ffd;
        private IOException exc;

        public OutputFileFlushResultMessage() {
        }

        public OutputFileFlushResultMessage(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
            super(2);
            this.ffd = n;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.outputFileFlushResult(jobFrontendRef, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class OutputFileWriteResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -4734876024127370851L;
        private int ffd;
        private IOException exc;

        public OutputFileWriteResultMessage() {
        }

        public OutputFileWriteResultMessage(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
            super(2);
            this.ffd = n;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.outputFileWriteResult(jobFrontendRef, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class OutputFileOpenResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 1460222094425830409L;
        private int bfd;
        private int ffd;
        private IOException exc;

        public OutputFileOpenResultMessage() {
        }

        public OutputFileOpenResultMessage(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
            super(2);
            this.bfd = n;
            this.ffd = n2;
            this.exc = iOException;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.outputFileOpenResult(jobFrontendRef, this.bfd, this.ffd, this.exc);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.bfd);
            objectOutput.writeInt(this.ffd);
            objectOutput.writeObject(this.exc);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.bfd = objectInput.readInt();
            this.ffd = objectInput.readInt();
            this.exc = (IOException)objectInput.readObject();
        }
    }

    private static class ReportResourceMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 8709827200639757997L;
        private String resourceName;
        private ByteSequence contentSeq;
        private byte[] content;

        public ReportResourceMessage() {
        }

        public ReportResourceMessage(JobFrontendRef jobFrontendRef, String string, byte[] byArray) {
            super(2);
            this.resourceName = string;
            this.content = byArray;
        }

        public ReportResourceMessage(JobFrontendRef jobFrontendRef, String string, ByteSequence byteSequence) {
            super(2);
            this.resourceName = string;
            this.contentSeq = byteSequence;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            if (this.content != null) {
                jobBackendRef.reportResource(jobFrontendRef, this.resourceName, this.content);
            } else {
                jobBackendRef.reportResource(jobFrontendRef, this.resourceName, this.contentSeq);
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.resourceName);
            if (this.content != null) {
                objectOutput.writeInt(this.content.length);
                objectOutput.write(this.content);
            } else if (this.contentSeq != null) {
                objectOutput.writeInt(this.contentSeq.length());
                this.contentSeq.write(objectOutput);
            } else {
                objectOutput.writeInt(-1);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.resourceName = objectInput.readUTF();
            int n = objectInput.readInt();
            if (n < 0) {
                this.content = null;
            } else {
                this.content = new byte[n];
                objectInput.readFully(this.content);
            }
        }
    }

    private static class RenewLeaseMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -5146916532326180730L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.renewLease(jobFrontendRef);
        }
    }

    private static class JobFinishedMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 1363549433797859519L;

        public JobFinishedMessage() {
        }

        public JobFinishedMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.jobFinished(jobFrontendRef);
        }
    }

    private static class CommenceJobMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -8262872991140404870L;
        private InetSocketAddress[] middlewareAddress;
        private InetSocketAddress[] worldAddress;
        private InetSocketAddress[] frontendAddress;
        private Properties properties;
        private String mainClassName;
        private String[] args;

        public CommenceJobMessage() {
        }

        public CommenceJobMessage(JobFrontendRef jobFrontendRef, InetSocketAddress[] inetSocketAddressArray, InetSocketAddress[] inetSocketAddressArray2, InetSocketAddress[] inetSocketAddressArray3, Properties properties, String string, String[] stringArray) {
            super(2);
            this.middlewareAddress = inetSocketAddressArray;
            this.worldAddress = inetSocketAddressArray2;
            this.frontendAddress = inetSocketAddressArray3;
            this.properties = properties;
            this.mainClassName = string;
            this.args = stringArray;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.commenceJob(jobFrontendRef, this.middlewareAddress, this.worldAddress, this.frontendAddress, this.properties, this.mainClassName, this.args);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            int n;
            objectOutput.writeInt(this.properties.size());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                objectOutput.writeUTF((String)entry.getKey());
                objectOutput.writeUTF((String)entry.getValue());
            }
            objectOutput.writeUTF(this.mainClassName);
            objectOutput.writeInt(this.args.length);
            for (String string : this.args) {
                objectOutput.writeUTF(string);
            }
            int n2 = this.middlewareAddress.length;
            int n3 = this.worldAddress.length;
            int n4 = this.frontendAddress == null ? 0 : this.frontendAddress.length;
            objectOutput.writeInt(n2);
            objectOutput.writeInt(n3);
            objectOutput.writeInt(n4);
            for (n = 0; n < n2; ++n) {
                objectOutput.writeObject(this.middlewareAddress[n]);
            }
            for (n = 0; n < n3; ++n) {
                objectOutput.writeObject(this.worldAddress[n]);
            }
            for (n = 0; n < n4; ++n) {
                objectOutput.writeObject(this.frontendAddress[n]);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n;
            int n2;
            int n3 = objectInput.readInt();
            this.properties = new Properties();
            for (n2 = 0; n2 < n3; ++n2) {
                this.properties.setProperty(objectInput.readUTF(), objectInput.readUTF());
            }
            this.mainClassName = objectInput.readUTF();
            n3 = objectInput.readInt();
            this.args = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.args[n2] = objectInput.readUTF();
            }
            n2 = objectInput.readInt();
            int n4 = objectInput.readInt();
            int n5 = objectInput.readInt();
            this.middlewareAddress = new InetSocketAddress[n2];
            for (n = 0; n < n2; ++n) {
                this.middlewareAddress[n] = (InetSocketAddress)objectInput.readObject();
            }
            this.worldAddress = new InetSocketAddress[n4];
            for (n = 0; n < n4; ++n) {
                this.worldAddress[n] = (InetSocketAddress)objectInput.readObject();
            }
            if (n5 > 0) {
                this.frontendAddress = new InetSocketAddress[n5];
                for (n = 0; n < n5; ++n) {
                    this.frontendAddress[n] = (InetSocketAddress)objectInput.readObject();
                }
            }
        }
    }

    private static class CancelJobMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -1706674774429384654L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobFrontendRef jobFrontendRef, String string) {
            super(2);
            this.errmsg = string;
        }

        public void invoke(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobBackendRef.cancelJob(jobFrontendRef, this.errmsg);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.errmsg);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.errmsg = objectInput.readUTF();
        }
    }
}

