/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.concurrent.atomic.AtomicInteger;

class GuidedIntegerSchedule
extends IntegerSchedule {
    private int two_K;
    private Range myLoopRange;
    private int myLoopRangeLength;
    private AtomicInteger N1 = new AtomicInteger();
    private int N2;

    public GuidedIntegerSchedule() {
        this(1);
    }

    public GuidedIntegerSchedule(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Minimum chunk size = " + n + " illegal");
        }
        this.N2 = n;
    }

    public GuidedIntegerSchedule(String[] stringArray) {
        this(GuidedIntegerSchedule.getChunkSize(stringArray));
    }

    private static int getChunkSize(String[] stringArray) {
        int n;
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Usage: -Dpj.schedule=guided or -Dpj.schedule=\"guided(<n>)\"");
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Chunk size = " + stringArray[0] + " illegal");
        }
        return n;
    }

    public boolean isFixedSchedule() {
        return false;
    }

    public void start(int n, Range range) {
        this.two_K = 2 * n;
        this.myLoopRange = range;
        this.myLoopRangeLength = range.length();
        this.N1.set(0);
    }

    public Range next(int n) {
        Range range;
        int n2;
        int n3;
        int n4;
        do {
            if ((n2 = (range = this.myLoopRange.chunk(n4 = this.N1.get(), Math.max(this.N2, (this.myLoopRangeLength - n4) / this.two_K))).length()) != 0) continue;
            return null;
        } while (!this.N1.compareAndSet(n4, n3 = n4 + n2));
        return range;
    }
}

