/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.plot.impl.NumericalAxis;
import edu.rit.numeric.plot.impl.Ticks;
import java.awt.Paint;
import java.awt.Stroke;

public class LinearAxis
extends NumericalAxis {
    private double myStart;
    private double myEnd;
    private double myMin;
    private double myMax;
    private double myRange;
    private double myLengthOverMyRange;
    private int myMajorDivisionCount;
    private double myMajorDivisionRange;
    private int myMinorDivisionCount;
    private double myMinorDivisionRange;
    private double myCrossing;

    public LinearAxis(double d, double d2, int n, int n2, double d3, double d4) {
        this(d, d2, n, n2, d3, d4, DEFAULT_STROKE, DEFAULT_PAINT, null, null);
    }

    public LinearAxis(double d, double d2, int n, int n2, double d3, double d4, Stroke stroke, Paint paint) {
        this(d, d2, n, n2, d3, d4, stroke, paint, null, null);
    }

    public LinearAxis(double d, double d2, int n, int n2, double d3, double d4, Ticks ticks, Ticks ticks2) {
        this(d, d2, n, n2, d3, d4, DEFAULT_STROKE, DEFAULT_PAINT, ticks, ticks2);
    }

    public LinearAxis(double d, double d2, int n, int n2, double d3, double d4, Stroke stroke, Paint paint, Ticks ticks, Ticks ticks2) {
        super(d4, stroke, paint, ticks, ticks2);
        if (d == d2 || n < 1 || n2 < 1 || Math.min(d, d2) > d3 || d3 > Math.max(d, d2)) {
            throw new IllegalArgumentException();
        }
        this.myStart = d;
        this.myEnd = d2;
        this.myMin = Math.min(d, d2);
        this.myMax = Math.max(d, d2);
        this.myRange = d2 - d;
        this.myLengthOverMyRange = this.myLength / this.myRange;
        this.myMajorDivisionCount = n;
        this.myMajorDivisionRange = this.myRange / (double)n;
        this.myMinorDivisionCount = n * n2;
        this.myMinorDivisionRange = this.myRange / (double)this.myMinorDivisionCount;
        this.myCrossing = d3;
    }

    public double getStart() {
        return this.myStart;
    }

    public double getEnd() {
        return this.myEnd;
    }

    public boolean includesValue(double d) {
        return this.myMin <= d && d <= this.myMax;
    }

    public double getDisplayDistance(double d) {
        return (d - this.myStart) * this.myLengthOverMyRange;
    }

    public int getMajorDivisionCount() {
        return this.myMajorDivisionCount;
    }

    public double getMajorDivision(int n) {
        return this.myStart + (double)n * this.myMajorDivisionRange;
    }

    public int getMinorDivisionCount() {
        return this.myMinorDivisionCount;
    }

    public double getMinorDivision(int n) {
        return this.myStart + (double)n * this.myMinorDivisionRange;
    }

    public double getCrossing() {
        return this.myCrossing;
    }

    public static double autoscale(double d) {
        double d2;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return -LinearAxis.autoscale(-d);
        }
        double d3 = 1.0;
        double d4 = 2.0;
        double d5 = 5.0;
        for (d2 = 10.0; d2 < d; d2 *= 10.0) {
            d3 *= 10.0;
            d4 *= 10.0;
            d5 *= 10.0;
        }
        while (!(d5 < d) || !(d <= d2)) {
            if (d4 < d && d <= d5) {
                return d5;
            }
            if (d3 < d && d <= d4) {
                return d4;
            }
            d3 /= 10.0;
            d4 /= 10.0;
            d5 /= 10.0;
            d2 /= 10.0;
        }
        return d2;
    }
}

