/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import java.awt.BasicStroke;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Strokes {
    private Strokes() {
    }

    public static BasicStroke solid(double d) {
        return new BasicStroke((float)d, 2, 0, 10.0f);
    }

    public static BasicStroke dotted(double d) {
        return Strokes.dashed(d, 1.0, 1.0);
    }

    public static BasicStroke dashed(double d) {
        return Strokes.dashed(d, 3.0, 1.0);
    }

    public static BasicStroke dashed(double d, double d2, double d3) {
        return new BasicStroke((float)d, 2, 0, 10.0f, new float[]{(float)((d2 - 1.0) * d), (float)((d3 + 1.0) * d)}, 0.0f);
    }

    public static BasicStroke roundSolid(double d) {
        return new BasicStroke((float)d, 1, 1, 10.0f);
    }

    public static BasicStroke roundDotted(double d) {
        return Strokes.roundDashed(d, 1.0, 1.0);
    }

    public static BasicStroke roundDashed(double d) {
        return Strokes.roundDashed(d, 3.0, 1.0);
    }

    public static BasicStroke roundDashed(double d, double d2, double d3) {
        return new BasicStroke((float)d, 1, 1, 10.0f, new float[]{(float)((d2 - 1.0) * d), (float)((d3 + 1.0) * d)}, 0.0f);
    }

    public static void writeExternal(BasicStroke basicStroke, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(basicStroke == null ? null : new StrokeWrapper(basicStroke));
    }

    public static BasicStroke readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        StrokeWrapper strokeWrapper = (StrokeWrapper)objectInput.readObject();
        return strokeWrapper == null ? null : strokeWrapper.getStroke();
    }

    private static class StrokeWrapper
    implements Externalizable {
        private static final long serialVersionUID = 6899737592162456726L;
        private float width;
        private int cap;
        private int join;
        private float miterlimit;
        private float[] dash;
        private float dash_phase;

        public StrokeWrapper() {
        }

        public StrokeWrapper(BasicStroke basicStroke) {
            this.width = basicStroke.getLineWidth();
            this.cap = basicStroke.getEndCap();
            this.join = basicStroke.getLineJoin();
            this.miterlimit = basicStroke.getMiterLimit();
            this.dash = basicStroke.getDashArray();
            this.dash_phase = basicStroke.getDashPhase();
        }

        public BasicStroke getStroke() {
            return new BasicStroke(this.width, this.cap, this.join, this.miterlimit, this.dash, this.dash_phase);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeFloat(this.width);
            objectOutput.writeInt(this.cap);
            objectOutput.writeInt(this.join);
            objectOutput.writeFloat(this.miterlimit);
            int n = this.dash == null ? 0 : this.dash.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeFloat(this.dash[i]);
            }
            objectOutput.writeFloat(this.dash_phase);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.width = objectInput.readFloat();
            this.cap = objectInput.readInt();
            this.join = objectInput.readInt();
            this.miterlimit = objectInput.readFloat();
            int n = objectInput.readInt();
            this.dash = n == 0 ? null : new float[n];
            for (int i = 0; i < n; ++i) {
                this.dash[i] = objectInput.readFloat();
            }
            this.dash_phase = objectInput.readFloat();
        }
    }
}

